/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Token;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.tree.PyBinaryExpressionTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="InequalityUsage")
public class InequalityUsageCheck
extends PythonSubscriptionCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, ctx -> {
            PyBinaryExpressionTree expr = (PyBinaryExpressionTree)ctx.syntaxNode();
            Token operator = expr.operator();
            if (operator.getValue().equals(PythonPunctuator.NOT_EQU2.getValue())) {
                ctx.addIssue(operator, "Replace \"<>\" by \"!=\".");
            }
        });
    }
}

