/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheckAstNode;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S2325")
public class MethodShouldBeStaticCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "S2325";
    private static final String MESSAGE = "Make this method static.";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    @Override
    public void visitNode(AstNode node) {
        String self;
        if (CheckUtils.isMethodOfNonDerivedClass(node) && !MethodShouldBeStaticCheck.alreadyStaticMethod(node) && !MethodShouldBeStaticCheck.isBuiltInMethod(node) && MethodShouldBeStaticCheck.hasValuableCode(node) && !MethodShouldBeStaticCheck.mayRaiseNotImplementedError(node) && (self = MethodShouldBeStaticCheck.getFirstArgument(node)) != null && !MethodShouldBeStaticCheck.isUsed(node, self)) {
            this.addIssue(node.getFirstChild(PythonGrammar.FUNCNAME), MESSAGE);
        }
    }

    private static boolean mayRaiseNotImplementedError(AstNode function) {
        return function.getDescendants(PythonGrammar.RAISE_STMT).stream().map(raise -> raise.getFirstDescendant(PythonGrammar.TEST)).filter(Objects::nonNull).anyMatch(test -> "NotImplementedError".equals(test.getToken().getValue()));
    }

    private static boolean hasValuableCode(AstNode funcDef) {
        AstNode statementList = funcDef.getFirstChild(PythonGrammar.SUITE).getFirstChild(PythonGrammar.STMT_LIST);
        if (statementList != null && statementList.getChildren(PythonGrammar.SIMPLE_STMT).size() == 1) {
            return !statementList.getFirstChild(PythonGrammar.SIMPLE_STMT).getFirstChild().is(PythonGrammar.PASS_STMT);
        }
        List<AstNode> statements = funcDef.getFirstChild(PythonGrammar.SUITE).getChildren(PythonGrammar.STATEMENT);
        if (statements.size() == 1) {
            return !MethodShouldBeStaticCheck.isDocstringOrPass(statements.get(0));
        }
        return statements.size() != 2 || !MethodShouldBeStaticCheck.isDocstringAndPass(statements.get(0), statements.get(1));
    }

    private static boolean isDocstringOrPass(AstNode statement) {
        return statement.getFirstDescendant(PythonGrammar.PASS_STMT) != null || statement.getToken().getType().equals(PythonTokenType.STRING);
    }

    private static boolean isDocstringAndPass(AstNode statement1, AstNode statement2) {
        return statement1.getToken().getType().equals(PythonTokenType.STRING) && statement2.getFirstDescendant(PythonGrammar.PASS_STMT) != null;
    }

    private static boolean isUsed(AstNode funcDef, String self) {
        List<AstNode> names = funcDef.getFirstChild(PythonGrammar.SUITE).getDescendants(PythonGrammar.NAME);
        for (AstNode name : names) {
            if (!name.getTokenValue().equals(self)) continue;
            return true;
        }
        return false;
    }

    private static String getFirstArgument(AstNode funcDef) {
        AstNode argList = funcDef.getFirstChild(PythonGrammar.TYPEDARGSLIST);
        if (argList != null) {
            return argList.getFirstDescendant(PythonGrammar.NAME).getTokenValue();
        }
        return null;
    }

    private static boolean alreadyStaticMethod(AstNode funcDef) {
        AstNode decorators = funcDef.getFirstChild(PythonGrammar.DECORATORS);
        if (decorators != null) {
            List<AstNode> decoratorList = decorators.getChildren(PythonGrammar.DECORATOR);
            for (AstNode decorator : decoratorList) {
                AstNode name = decorator.getFirstDescendant(PythonGrammar.NAME);
                if (name == null || !"staticmethod".equals(name.getTokenValue()) && !"classmethod".equals(name.getTokenValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBuiltInMethod(AstNode funcDef) {
        String doubleUnderscore;
        String name = funcDef.getFirstChild(PythonGrammar.FUNCNAME).getToken().getValue();
        return name.startsWith(doubleUnderscore = "__") && name.endsWith(doubleUnderscore);
    }
}

