/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyClassDefTree;
import org.sonar.python.api.tree.PyFileInputTree;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1720")
public class MissingDocstringCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S1720";
    private static final Pattern EMPTY_STRING_REGEXP = Pattern.compile("([bruBRU]+)?('\\s*')|(\"\\s*\")|('''\\s*''')|(\"\"\"\\s*\"\"\")");
    private static final String MESSAGE_NO_DOCSTRING = "Add a docstring to this %s.";
    private static final String MESSAGE_EMPTY_DOCSTRING = "The docstring for this %s should not be empty.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> MissingDocstringCheck.checkDocString(ctx, ((PyFileInputTree)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> MissingDocstringCheck.checkDocString(ctx, ((PyFunctionDefTree)ctx.syntaxNode()).docstring()));
        context.registerSyntaxNodeConsumer(Tree.Kind.CLASSDEF, ctx -> MissingDocstringCheck.checkDocString(ctx, ((PyClassDefTree)ctx.syntaxNode()).docstring()));
    }

    private static void checkDocString(SubscriptionContext ctx, @CheckForNull Token docstring) {
        Tree tree = ctx.syntaxNode();
        DeclarationType type = MissingDocstringCheck.getType(tree);
        if (docstring == null) {
            MissingDocstringCheck.raiseIssueNoDocstring(tree, type, ctx);
        } else if (EMPTY_STRING_REGEXP.matcher(docstring.getValue()).matches()) {
            MissingDocstringCheck.raiseIssue(tree, MESSAGE_EMPTY_DOCSTRING, type, ctx);
        }
    }

    private static DeclarationType getType(Tree tree) {
        if (tree.is(Tree.Kind.FUNCDEF)) {
            if (((PyFunctionDefTree)tree).isMethodDefinition()) {
                return DeclarationType.METHOD;
            }
            return DeclarationType.FUNCTION;
        }
        if (tree.is(Tree.Kind.CLASSDEF)) {
            return DeclarationType.CLASS;
        }
        return DeclarationType.MODULE;
    }

    private static void raiseIssueNoDocstring(Tree tree, DeclarationType type, SubscriptionContext ctx) {
        if (type != DeclarationType.METHOD) {
            MissingDocstringCheck.raiseIssue(tree, MESSAGE_NO_DOCSTRING, type, ctx);
        }
    }

    private static void raiseIssue(Tree tree, String message, DeclarationType type, SubscriptionContext ctx) {
        String finalMessage = String.format(message, type.value);
        if (type != DeclarationType.MODULE) {
            ctx.addIssue(MissingDocstringCheck.getNameNode(tree), finalMessage);
        } else {
            ctx.addFileIssue(finalMessage);
        }
    }

    private static PyNameTree getNameNode(Tree tree) {
        if (tree.is(Tree.Kind.FUNCDEF)) {
            return ((PyFunctionDefTree)tree).name();
        }
        return ((PyClassDefTree)tree).name();
    }

    private static enum DeclarationType {
        MODULE("module"),
        CLASS("class"),
        METHOD("method"),
        FUNCTION("function");

        private final String value;

        private DeclarationType(String value) {
            this.value = value;
        }
    }
}

