/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyUnaryExpressionTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="PreIncrementDecrement")
public class PreIncrementDecrementCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "PreIncrementDecrement";
    private static final String MESSAGE = "This statement doesn't produce the expected result, replace use of non-existent pre-%srement operator";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.UNARY_PLUS, PreIncrementDecrementCheck::checkIncrementDecrement);
        context.registerSyntaxNodeConsumer(Tree.Kind.UNARY_MINUS, PreIncrementDecrementCheck::checkIncrementDecrement);
    }

    private static void checkIncrementDecrement(SubscriptionContext ctx) {
        PyUnaryExpressionTree unaryExpressionTree = (PyUnaryExpressionTree)ctx.syntaxNode();
        Tree.Kind kind = unaryExpressionTree.getKind();
        if (unaryExpressionTree.expression().is(kind)) {
            ctx.addIssue(unaryExpressionTree, String.format(MESSAGE, kind == Tree.Kind.UNARY_PLUS ? "inc" : "dec"));
        }
    }
}

