/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyReturnStatementTree;
import org.sonar.python.api.tree.PyYieldStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S2712")
public class ReturnAndYieldInOneFunctionCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S2712";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            PyFunctionDefTree func = (PyFunctionDefTree)ctx.syntaxNode();
            ReturnAndYieldVisitor returnAndYieldVisitor = new ReturnAndYieldVisitor();
            func.body().accept(returnAndYieldVisitor);
            if (returnAndYieldVisitor.hasYield && returnAndYieldVisitor.hasReturn) {
                ctx.addIssue(func.name(), "Use only \"return\" or only \"yield\", not both.");
            }
        });
    }

    private static class ReturnAndYieldVisitor
    extends BaseTreeVisitor {
        private boolean hasYield = false;
        private boolean hasReturn = false;

        private ReturnAndYieldVisitor() {
        }

        @Override
        public void visitFunctionDef(PyFunctionDefTree pyFunctionDefTree) {
        }

        @Override
        public void visitReturnStatement(PyReturnStatementTree pyReturnStatementTree) {
            if (!pyReturnStatementTree.expressions().isEmpty()) {
                this.hasReturn = true;
            }
        }

        @Override
        public void visitYieldStatement(PyYieldStatementTree pyYieldStatementTree) {
            this.hasYield = true;
        }
    }
}

