/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheckAstNode;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
extends PythonCheckAstNode {
    public static final String CHECK_KEY = "S1131";
    public static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern TRAILING_WS = Pattern.compile("\\s$");

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        String[] lines = this.getContext().pythonFile().content().split("\r\n|\n|\r", -1);
        for (int i = 0; i < lines.length; ++i) {
            if (!TRAILING_WS.matcher(lines[i]).find()) continue;
            this.addLineIssue(MESSAGE, i + 1);
        }
    }
}

