/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4423")
public class WeakSSLProtocolCheck
extends PythonSubscriptionCheck {
    private static final List<String> WEAK_PROTOCOL_CONSTANTS = Arrays.asList("ssl.PROTOCOL_SSLv2", "ssl.PROTOCOL_SSLv3", "ssl.PROTOCOL_SSLv23", "ssl.PROTOCOL_TLS", "ssl.PROTOCOL_TLSv1", "ssl.PROTOCOL_TLSv1_1", "OpenSSL.SSL.SSLv2_METHOD", "OpenSSL.SSL.SSLv3_METHOD", "OpenSSL.SSL.SSLv23_METHOD", "OpenSSL.SSL.TLSv1_METHOD", "OpenSSL.SSL.TLSv1_1_METHOD");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ctx -> {
            Symbol symbol;
            PyNameTree pyNameTree = (PyNameTree)ctx.syntaxNode();
            if (WeakSSLProtocolCheck.isWeakProtocol(pyNameTree, symbol = ctx.symbolTable().getSymbol(pyNameTree))) {
                ctx.addIssue(pyNameTree, "Change this code to use a stronger protocol.");
            }
        });
    }

    private static boolean isWeakProtocol(PyNameTree pyNameTree, @Nullable Symbol symbol) {
        Predicate<String> matchWeakProtocol = symbol == null ? s -> s.substring(s.lastIndexOf(46) + 1).equals(pyNameTree.name()) : symbol.qualifiedName()::equals;
        return WEAK_PROTOCOL_CONSTANTS.stream().anyMatch(matchWeakProtocol);
    }
}

