/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4823")
public class CommandLineArgsCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S4823";
    private static final String MESSAGE = "Make sure that command line arguments are used safely here.";
    private static final Set<String> questionableFunctions = CommandLineArgsCheck.immutableSet("argparse.ArgumentParser", "optparse.OptionParser");

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, CommandLineArgsCheck::checkSysArgNode);
        super.initialize(context);
    }

    private static void checkSysArgNode(SubscriptionContext ctx) {
        Tree node = ctx.syntaxNode();
        Tree parent = node.parent();
        Symbol symbol = ctx.symbolTable().getSymbol((PyNameTree)node);
        if (symbol == null && parent != null) {
            symbol = ctx.symbolTable().getSymbol(parent.astNode());
            node = parent;
        }
        if (symbol != null && symbol.qualifiedName().equals("sys.argv")) {
            if (CommandLineArgsCheck.isWithinImport(parent)) {
                return;
            }
            ctx.addIssue(node, MESSAGE);
        }
    }

    @Override
    protected Set<String> functionsToCheck() {
        return questionableFunctions;
    }

    @Override
    protected String message() {
        return MESSAGE;
    }
}

