/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyAssignmentStatementTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionListTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;

@Rule(key="S4507")
public class DebugModeCheck
extends PythonSubscriptionCheck {
    public static final String CHECK_KEY = "S4507";
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private static final Set<String> debugProperties = new HashSet<String>(Arrays.asList("DEBUG", "DEBUG_PROPAGATE_EXCEPTIONS"));

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            PyCallExpressionTree callExpression = (PyCallExpressionTree)ctx.syntaxNode();
            List<PyArgumentTree> arguments = callExpression.arguments();
            if (!(callExpression.callee() instanceof PyQualifiedExpressionTree)) {
                return;
            }
            PyQualifiedExpressionTree callee = (PyQualifiedExpressionTree)callExpression.callee();
            if (DebugModeCheck.getQualifiedName(callee.qualifier(), ctx).equals("django.conf.settings") && callee.name().name().equals("configure") && !arguments.isEmpty()) {
                arguments.stream().filter(DebugModeCheck::isDebugArgument).forEach(arg -> ctx.addIssue((Tree)arg, MESSAGE));
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            if (!ctx.pythonFile().fileName().equals("global_settings.py")) {
                return;
            }
            PyAssignmentStatementTree assignmentStatementTree = (PyAssignmentStatementTree)ctx.syntaxNode();
            for (PyExpressionListTree lhsExpression : assignmentStatementTree.lhsExpressions()) {
                boolean isDebugProperties = lhsExpression.expressions().stream().anyMatch(DebugModeCheck::isDebugIdentifier);
                if (!isDebugProperties || !DebugModeCheck.isTrueLiteral(assignmentStatementTree.assignedValue())) continue;
                ctx.addIssue(assignmentStatementTree, MESSAGE);
            }
        });
    }

    private static boolean isDebugIdentifier(PyExpressionTree expr) {
        return expr.is(Tree.Kind.NAME) && debugProperties.contains(((PyNameTree)expr).name());
    }

    private static boolean isTrueLiteral(PyExpressionTree expr) {
        return expr.is(Tree.Kind.NAME) && ((PyNameTree)expr).name().equals("True");
    }

    private static boolean isDebugArgument(PyArgumentTree argument) {
        PyNameTree keywordArgument = argument.keywordArgument();
        if (keywordArgument != null && debugProperties.contains(keywordArgument.name())) {
            return DebugModeCheck.isTrueLiteral(argument.expression());
        }
        return false;
    }

    private static String getQualifiedName(PyExpressionTree node, SubscriptionContext ctx) {
        Symbol symbol = ctx.symbolTable().getSymbol(node);
        return symbol != null ? symbol.qualifiedName() : "";
    }
}

