/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.Tree;

@Rule(key="S1523")
public class DynamicCodeExecutionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure that this dynamic injection or execution of code is safe.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            PyCallExpressionTree callExpr = (PyCallExpressionTree)ctx.syntaxNode();
            if (DynamicCodeExecutionCheck.isFuncNameExecOrEval(callExpr)) {
                ctx.addIssue(callExpr, MESSAGE);
            }
        });
    }

    private static boolean isFuncNameExecOrEval(PyCallExpressionTree call) {
        PyExpressionTree expr = call.callee();
        if (expr.is(Tree.Kind.NAME)) {
            String functionName = ((PyNameTree)expr).name();
            return functionName.equals("exec") || functionName.equals("eval");
        }
        return false;
    }
}

