/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.python.PythonSubscriptionCheck;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.PyStringElementTree;
import org.sonar.python.api.tree.PyStringLiteralTree;
import org.sonar.python.api.tree.PySubscriptionExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.SymbolTable;

@Rule(key="S5443")
public class PubliclyWritableDirectoriesCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Make sure publicly writable directories are used safely here.";
    private static final List<String> UNIX_WRITABLE_DIRECTORIES = Arrays.asList("/tmp/", "/var/tmp/", "/usr/tmp/", "/dev/shm/", "/dev/mqueue/", "/run/lock/", "/var/run/lock/", "/library/caches/", "/users/shared/", "/private/tmp/", "/private/var/tmp/");
    private static final List<String> NONCOMPLIANT_ENVIRON_VARIABLES = Arrays.asList("tmpdir", "tmp");
    private static final Pattern WINDOWS_WRITABLE_DIRECTORIES = Pattern.compile("[^\\\\]*\\\\(Windows\\\\Temp|Temp|TMP)(\\\\.*|$)", 2);

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, ctx -> {
            PyStringElementTree tree = (PyStringElementTree)ctx.syntaxNode();
            String stringElement = tree.trimmedQuotesValue().toLowerCase(Locale.ENGLISH);
            if (UNIX_WRITABLE_DIRECTORIES.stream().anyMatch(dir -> PubliclyWritableDirectoriesCheck.containsDirectory(stringElement, dir)) || WINDOWS_WRITABLE_DIRECTORIES.matcher(stringElement).matches()) {
                ctx.addIssue(tree, MESSAGE);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            PyCallExpressionTree tree = (PyCallExpressionTree)ctx.syntaxNode();
            List<PyArgumentTree> arguments = tree.arguments();
            if (PubliclyWritableDirectoriesCheck.isOsEnvironGetter(tree.callee(), ctx.symbolTable()) && arguments.stream().map(PyArgumentTree::expression).anyMatch(PubliclyWritableDirectoriesCheck::isNonCompliantOsEnvironArgument)) {
                ctx.addIssue(tree, MESSAGE);
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.SUBSCRIPTION, ctx -> {
            PySubscriptionExpressionTree tree = (PySubscriptionExpressionTree)ctx.syntaxNode();
            if (PubliclyWritableDirectoriesCheck.isOsEnvironQualifiedExpression(tree.object(), ctx.symbolTable()) && tree.subscripts().expressions().stream().anyMatch(PubliclyWritableDirectoriesCheck::isNonCompliantOsEnvironArgument)) {
                ctx.addIssue(tree, MESSAGE);
            }
        });
    }

    private static boolean containsDirectory(String stringElement, String dir) {
        return stringElement.startsWith(dir) || stringElement.equals(dir.substring(0, dir.length() - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNonCompliantOsEnvironArgument(PyExpressionTree expression) {
        if (!expression.is(Tree.Kind.STRING_LITERAL)) return false;
        if (!((PyStringLiteralTree)expression).stringElements().stream().map(s -> s.trimmedQuotesValue().toLowerCase(Locale.ENGLISH)).anyMatch(NONCOMPLIANT_ENVIRON_VARIABLES::contains)) return false;
        return true;
    }

    private static boolean isOsEnvironGetter(PyExpressionTree expression, SymbolTable symbolTable) {
        if (!expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return false;
        }
        PyQualifiedExpressionTree qualifiedExpression = (PyQualifiedExpressionTree)expression;
        if (qualifiedExpression.name().name().equals("get")) {
            return PubliclyWritableDirectoriesCheck.isOsEnvironQualifiedExpression(qualifiedExpression.qualifier(), symbolTable);
        }
        return false;
    }

    private static boolean isOsEnvironQualifiedExpression(PyExpressionTree expression, SymbolTable symbolTable) {
        Symbol symbol = symbolTable.getSymbol(expression);
        if (symbol != null) {
            return symbol.qualifiedName().equals("os.environ");
        }
        if (!expression.is(Tree.Kind.QUALIFIED_EXPR)) {
            return false;
        }
        PyQualifiedExpressionTree qualifiedExpression = (PyQualifiedExpressionTree)expression;
        if (qualifiedExpression.qualifier().is(Tree.Kind.NAME)) {
            return ((PyNameTree)qualifiedExpression.qualifier()).name().equals("os") && qualifiedExpression.name().name().equals("environ");
        }
        return false;
    }
}

