/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.SubscriptionCheck;
import org.sonar.python.SubscriptionContext;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyBinaryExpressionTree;
import org.sonar.python.api.tree.PyCallExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.PyStringLiteralTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.checks.AbstractCallExpressionCheck;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.BaseTreeVisitor;

@Rule(key="S2077")
public class SQLQueriesCheck
extends AbstractCallExpressionCheck {
    public static final String CHECK_KEY = "S2077";
    private static final String MESSAGE = "Make sure that formatting this SQL query is safe here.";
    private boolean isUsingDjangoModel = false;
    private boolean isUsingDjangoDBConnection = false;

    @Override
    protected Set<String> functionsToCheck() {
        return Collections.singleton("django.db.models.expressions.RawSQL");
    }

    @Override
    protected String message() {
        return MESSAGE;
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        super.initialize(context);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::visitFile);
    }

    private void visitFile(SubscriptionContext ctx) {
        this.isUsingDjangoModel = false;
        this.isUsingDjangoDBConnection = false;
        for (Symbol symbol : ctx.symbolTable().symbols(ctx.syntaxNode().astNode())) {
            String qualifiedName = symbol.qualifiedName();
            if (qualifiedName.contains("django.db.models")) {
                this.isUsingDjangoModel = true;
            }
            if (!qualifiedName.contains("django.db.connection")) continue;
            this.isUsingDjangoDBConnection = true;
        }
    }

    private boolean isSQLQueryFromDjangoModel(String functionName) {
        return this.isUsingDjangoModel && (functionName.equals("raw") || functionName.equals("extra"));
    }

    private boolean isSQLQueryFromDjangoDBConnection(String functionName) {
        return this.isUsingDjangoDBConnection && functionName.equals("execute");
    }

    @Override
    public void visitNode(SubscriptionContext context) {
        String functionName;
        PyCallExpressionTree callExpressionTree = (PyCallExpressionTree)context.syntaxNode();
        if (callExpressionTree.callee().is(Tree.Kind.QUALIFIED_EXPR) && (this.isSQLQueryFromDjangoModel(functionName = ((PyQualifiedExpressionTree)callExpressionTree.callee()).name().name()) || this.isSQLQueryFromDjangoDBConnection(functionName)) && !SQLQueriesCheck.isException(callExpressionTree, functionName)) {
            context.addIssue(callExpressionTree, MESSAGE);
        }
        super.visitNode(context);
    }

    private static boolean isException(PyCallExpressionTree callExpression, String functionName) {
        List<PyArgumentTree> argListNode = callExpression.arguments();
        if (SQLQueriesCheck.extraContainsFormattedSqlQueries(argListNode, functionName)) {
            return false;
        }
        if (argListNode.isEmpty()) {
            return true;
        }
        PyArgumentTree arg = argListNode.get(0);
        return !SQLQueriesCheck.isFormatted(arg.expression());
    }

    @Override
    protected boolean isException(PyCallExpressionTree callExpression) {
        return SQLQueriesCheck.isException(callExpression, "");
    }

    private static boolean isFormatted(PyExpressionTree tree) {
        FormattedStringVisitor visitor = new FormattedStringVisitor();
        tree.accept(visitor);
        return visitor.hasFormattedString;
    }

    private static boolean extraContainsFormattedSqlQueries(List<PyArgumentTree> argListNode, String functionName) {
        if (functionName.equals("extra")) {
            return argListNode.stream().filter(SQLQueriesCheck::isAssignment).map(PyArgumentTree::expression).anyMatch(SQLQueriesCheck::isFormatted);
        }
        return false;
    }

    private static boolean isAssignment(PyArgumentTree arg) {
        return arg.equalToken() != null;
    }

    private static class FormattedStringVisitor
    extends BaseTreeVisitor {
        boolean hasFormattedString = false;

        private FormattedStringVisitor() {
        }

        @Override
        public void visitStringLiteral(PyStringLiteralTree pyStringLiteralTree) {
            super.visitStringLiteral(pyStringLiteralTree);
            this.hasFormattedString |= pyStringLiteralTree.stringElements().stream().anyMatch(se -> se.prefix().equalsIgnoreCase("f"));
        }

        @Override
        public void visitCallExpression(PyCallExpressionTree pyCallExpressionTree) {
            if (pyCallExpressionTree.callee().is(Tree.Kind.QUALIFIED_EXPR)) {
                PyQualifiedExpressionTree callee = (PyQualifiedExpressionTree)pyCallExpressionTree.callee();
                this.hasFormattedString |= callee.name().name().equals("format") && callee.qualifier().is(Tree.Kind.STRING_LITERAL);
            }
            super.visitCallExpression(pyCallExpressionTree);
        }

        @Override
        public void visitBinaryExpression(PyBinaryExpressionTree pyBinaryExpressionTree) {
            this.hasFormattedString |= pyBinaryExpressionTree.leftOperand().is(Tree.Kind.STRING_LITERAL) || pyBinaryExpressionTree.rightOperand().is(Tree.Kind.STRING_LITERAL);
            super.visitBinaryExpression(pyBinaryExpressionTree);
        }
    }
}

