/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.PythonVisitor;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.semantic.SymbolTable;
import org.sonar.sslr.ast.AstSelect;

public class SymbolTableBuilderVisitor
extends PythonVisitor {
    private Map<AstNode, Scope> scopesByRootTree;
    private Set<AstNode> allReadUsages;
    private Map<String, Module> importedModules = new HashMap<String, Module>();
    private Map<AstNode, Symbol> symbolByNode = new HashMap<AstNode, Symbol>();

    public SymbolTable symbolTable() {
        return new SymbolTablImpl(this.scopesByRootTree, this.symbolByNode);
    }

    @Override
    public void scanFile(PythonVisitorContext context) {
        super.scanFile(context);
        new FirstPhaseVisitor().scanFile(context);
        new SecondPhaseVisitor().scanFile(context);
    }

    @Override
    public void visitFile(AstNode node) {
        this.scopesByRootTree = new HashMap<AstNode, Scope>();
        this.allReadUsages = new HashSet<AstNode>();
    }

    @CheckForNull
    private static String qualifiedName(@Nullable String moduleName, String symbolName) {
        return moduleName == null ? null : moduleName + "." + symbolName;
    }

    private static class Module {
        final String name;
        final String alias;
        final Scope scope;

        Module(String name, Scope scope, @Nullable String alias) {
            this.name = name;
            this.alias = alias;
            this.scope = scope;
        }
    }

    private class ClassVariableAssignmentVisitor
    extends SecondPhaseVisitor {
        public ClassVariableAssignmentVisitor(AstNode classTree) {
            this.enterScope(classTree);
        }
    }

    private class SecondPhaseVisitor
    extends ScopeVisitor {
        private SecondPhaseVisitor() {
        }

        @Override
        public Set<AstNodeType> subscribedKinds() {
            HashSet<PythonGrammar> set = new HashSet<PythonGrammar>();
            set.add(PythonGrammar.FUNCDEF);
            set.add(PythonGrammar.LAMBDEF);
            set.add(PythonGrammar.LAMBDEF_NOCOND);
            set.add(PythonGrammar.CLASSDEF);
            set.add(PythonGrammar.ATOM);
            set.add(PythonGrammar.DOTTED_NAME);
            set.add(PythonGrammar.CALL_EXPR);
            return Collections.unmodifiableSet(set);
        }

        @Override
        public void visitNode(AstNode node) {
            super.visitNode(node);
            if (node.is(PythonGrammar.ATOM, PythonGrammar.DOTTED_NAME)) {
                Scope currentScope;
                SymbolImpl symbol;
                AstNode nameNode = node.getFirstChild(PythonGrammar.NAME);
                if (nameNode != null && (symbol = (currentScope = (Scope)SymbolTableBuilderVisitor.this.scopesByRootTree.get(this.currentScopeRootTree())).resolve(nameNode.getTokenValue())) != null && !symbol.writeUsages.contains(nameNode) && !SymbolTableBuilderVisitor.this.allReadUsages.contains(nameNode)) {
                    symbol.addReadUsage(nameNode);
                    SymbolTableBuilderVisitor.this.allReadUsages.add(nameNode);
                    SymbolTableBuilderVisitor.this.symbolByNode.put(node, symbol);
                }
            } else if (node.is(PythonGrammar.CALL_EXPR)) {
                this.addSymbolForCallExpression(node);
            }
        }

        private void addSymbolForCallExpression(AstNode node) {
            Scope currentScope = (Scope)SymbolTableBuilderVisitor.this.scopesByRootTree.get(this.currentScopeRootTree());
            String symbolName = "";
            AstNode firstChild = node.getFirstChild();
            if (firstChild.is(PythonGrammar.ATTRIBUTE_REF)) {
                symbolName = firstChild.getChildren(PythonGrammar.ATOM, PythonGrammar.NAME).stream().map(AstNode::getTokenValue).collect(Collectors.joining("."));
            } else if (firstChild.is(PythonGrammar.ATOM)) {
                symbolName = firstChild.getTokenValue();
            }
            SymbolImpl symbol = currentScope.resolve(symbolName);
            if (symbol != null) {
                if (firstChild.is(PythonGrammar.ATOM)) {
                    symbol.addReadUsage(node);
                }
                SymbolTableBuilderVisitor.this.symbolByNode.put(node, symbol);
            }
        }
    }

    private static class SymbolImpl
    implements Symbol {
        private final String name;
        private final String qualifiedName;
        private final AstNode scopeRootTree;
        private final Set<AstNode> writeUsages = new HashSet<AstNode>();
        private final Set<AstNode> readUsages = new HashSet<AstNode>();

        private SymbolImpl(String name, AstNode scopeRootTree, @Nullable String qualifiedName) {
            this.name = name;
            this.scopeRootTree = scopeRootTree;
            this.qualifiedName = qualifiedName;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public AstNode scopeTree() {
            return this.scopeRootTree;
        }

        @Override
        public Set<AstNode> writeUsages() {
            return Collections.unmodifiableSet(this.writeUsages);
        }

        @Override
        public Set<AstNode> readUsages() {
            return Collections.unmodifiableSet(this.readUsages);
        }

        @Override
        public String qualifiedName() {
            if (this.qualifiedName == null) {
                return this.name;
            }
            return this.qualifiedName;
        }

        public void addWriteUsage(AstNode nameNode) {
            this.writeUsages.add(nameNode);
        }

        public void addReadUsage(AstNode nameNode) {
            this.readUsages.add(nameNode);
        }
    }

    private class Scope {
        private final AstNode rootTree;
        private final Scope parent;
        private final Map<String, Symbol> symbolsByName = new HashMap<String, Symbol>();
        private final Set<Symbol> symbols = new HashSet<Symbol>();
        private final Set<String> globalNames = new HashSet<String>();
        private final Set<String> nonlocalNames = new HashSet<String>();

        private Scope(Scope parent, AstNode rootTree) {
            this.parent = parent;
            this.rootTree = rootTree;
        }

        private Set<Symbol> symbols() {
            return Collections.unmodifiableSet(this.symbols);
        }

        public void addWriteUsage(AstNode nameNode) {
            this.addWriteUsage(nameNode, null);
        }

        public void addWriteUsage(AstNode nameNode, @Nullable String moduleName) {
            SymbolImpl symbol;
            String symbolName = nameNode.getTokenValue();
            if (!(this.symbolsByName.containsKey(symbolName) || this.globalNames.contains(symbolName) || this.nonlocalNames.contains(symbolName))) {
                symbol = new SymbolImpl(symbolName, this.rootTree, SymbolTableBuilderVisitor.qualifiedName(moduleName, symbolName));
                this.symbols.add(symbol);
                this.symbolsByName.put(symbolName, symbol);
                SymbolTableBuilderVisitor.this.symbolByNode.put(nameNode, symbol);
            }
            if ((symbol = this.resolve(symbolName)) != null) {
                symbol.addWriteUsage(nameNode);
            }
        }

        @CheckForNull
        public SymbolImpl resolve(String symbolName) {
            if (this.nonlocalNames.contains(symbolName)) {
                return this.resolveNonlocal(symbolName);
            }
            Symbol symbol = this.symbolsByName.get(symbolName);
            if (this.parent == null || symbol != null) {
                return (SymbolImpl)symbol;
            }
            if (this.globalNames.contains(symbolName)) {
                return this.rootScope().resolve(symbolName);
            }
            return this.parent.resolve(symbolName);
        }

        private SymbolImpl resolveNonlocal(String symbolName) {
            Scope scope = this.parent;
            while (scope.parent != null) {
                Symbol symbol = scope.symbolsByName.get(symbolName);
                if (symbol != null) {
                    return (SymbolImpl)symbol;
                }
                scope = scope.parent;
            }
            return null;
        }

        private Scope rootScope() {
            Scope scope = this;
            while (scope.parent != null) {
                scope = scope.parent;
            }
            return scope;
        }

        private void addGlobalName(String name) {
            this.globalNames.add(name);
        }

        private void addNonlocalName(String name) {
            this.nonlocalNames.add(name);
        }
    }

    private static class SymbolTablImpl
    implements SymbolTable {
        private final Map<AstNode, Scope> scopesByRootTree;
        private final Map<AstNode, Symbol> symbolByNode;

        public SymbolTablImpl(Map<AstNode, Scope> scopesByRootTree, Map<AstNode, Symbol> symbolByNode) {
            this.scopesByRootTree = scopesByRootTree;
            this.symbolByNode = Collections.unmodifiableMap(symbolByNode);
        }

        @Override
        public Set<Symbol> symbols(AstNode scopeTree) {
            Scope scope = this.scopesByRootTree.get(scopeTree);
            return scope == null ? Collections.emptySet() : scope.symbols();
        }

        @Override
        @CheckForNull
        public Symbol getSymbol(AstNode node) {
            return this.symbolByNode.get(node);
        }

        @Override
        @CheckForNull
        public Symbol getSymbol(PyExpressionTree expression) {
            AstNode parent;
            AstNode astNode = expression.astNode();
            if (astNode != null && astNode.is(PythonGrammar.NAME) && ((parent = astNode.getParent()).is(PythonGrammar.ATOM) || parent.is(PythonGrammar.ATTRIBUTE_REF) && parent.getLastChild(PythonGrammar.NAME) == astNode)) {
                return this.getSymbol(astNode.getParent());
            }
            return this.getSymbol(astNode);
        }
    }

    private class FirstPhaseVisitor
    extends ScopeVisitor {
        private FirstPhaseVisitor() {
        }

        @Override
        public Set<AstNodeType> subscribedKinds() {
            HashSet<PythonGrammar> set = new HashSet<PythonGrammar>();
            set.add(PythonGrammar.FUNCDEF);
            set.add(PythonGrammar.LAMBDEF);
            set.add(PythonGrammar.LAMBDEF_NOCOND);
            set.add(PythonGrammar.FOR_STMT);
            set.add(PythonGrammar.COMP_FOR);
            set.add(PythonGrammar.CLASSDEF);
            set.add(PythonGrammar.EXPRESSION_STMT);
            set.add(PythonGrammar.GLOBAL_STMT);
            set.add(PythonGrammar.NONLOCAL_STMT);
            set.add(PythonGrammar.IMPORT_STMT);
            set.add(PythonGrammar.ATTRIBUTE_REF);
            return Collections.unmodifiableSet(set);
        }

        @Override
        public void visitFile(AstNode node) {
            super.visitFile(node);
            this.createScope(node, null);
        }

        @Override
        public void visitNode(AstNode node) {
            Scope currentScope = this.currentScope();
            super.visitNode(node);
            if (node.is(PythonGrammar.FUNCDEF)) {
                this.createScope(node, currentScope);
                this.createFunctionParameters(node);
            } else if (node.is(PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND)) {
                this.createScope(node, currentScope);
                this.createLambdaParameters(node);
            } else if (node.is(PythonGrammar.FOR_STMT, PythonGrammar.COMP_FOR)) {
                this.createLoopVariables(node);
            } else if (node.is(PythonGrammar.CLASSDEF)) {
                this.createScope(node, currentScope);
            } else if (node.is(PythonGrammar.EXPRESSION_STMT)) {
                this.visitAssignment(node);
            } else if (node.is(PythonGrammar.GLOBAL_STMT)) {
                node.getChildren(PythonGrammar.NAME).forEach(name -> this.currentScope().addGlobalName(name.getTokenValue()));
            } else if (node.is(PythonGrammar.NONLOCAL_STMT)) {
                node.getChildren(PythonGrammar.NAME).forEach(name -> this.currentScope().addNonlocalName(name.getTokenValue()));
            } else if (node.is(PythonGrammar.IMPORT_STMT)) {
                this.visitImportStatement(node);
            } else if (node.is(PythonGrammar.ATTRIBUTE_REF)) {
                this.addSymbolForAttributeRef(node);
            }
        }

        private void addSymbolForAttributeRef(AstNode attributeRef) {
            String symbolName = attributeRef.getChildren(PythonGrammar.ATOM, PythonGrammar.NAME).stream().map(AstNode::getTokenValue).collect(Collectors.joining("."));
            String propertyName = attributeRef.getLastChild(PythonGrammar.NAME).getTokenValue();
            String namespace = symbolName.replaceAll("\\." + propertyName, "");
            Module module = (Module)SymbolTableBuilderVisitor.this.importedModules.get(namespace);
            if (module != null) {
                SymbolImpl symbol = module.scope.resolve(symbolName);
                if (symbol == null) {
                    String qualifiedName = SymbolTableBuilderVisitor.qualifiedName(module.name, propertyName);
                    symbol = new SymbolImpl(symbolName, module.scope.rootTree, qualifiedName);
                    module.scope.symbols.add(symbol);
                    module.scope.symbolsByName.put(symbolName, symbol);
                }
                symbol.addReadUsage(attributeRef);
                SymbolTableBuilderVisitor.this.symbolByNode.put(attributeRef, symbol);
            }
        }

        private void visitImportStatement(AstNode importNode) {
            AstNode dottedName;
            AstNode node = importNode.getFirstChild();
            if (node.is(PythonGrammar.IMPORT_NAME)) {
                node.getDescendants(PythonGrammar.DOTTED_AS_NAME).forEach(dottedAsName -> this.addImportedSymbols(dottedAsName.getFirstChild(PythonGrammar.DOTTED_NAME), dottedAsName.getFirstChild(PythonGrammar.NAME)));
            } else if (node.is(PythonGrammar.IMPORT_FROM) && (dottedName = node.getFirstChild(PythonGrammar.DOTTED_NAME)) != null) {
                String moduleName = dottedName.getChildren(PythonGrammar.NAME).stream().map(AstNode::getTokenValue).collect(Collectors.joining("."));
                node.getDescendants(PythonGrammar.IMPORT_AS_NAME).forEach(importAsName -> {
                    if (importAsName.getChildren(PythonGrammar.NAME).size() == 1) {
                        this.currentScope().addWriteUsage(importAsName.getFirstChild(PythonGrammar.NAME), moduleName);
                    }
                });
            }
        }

        private void addImportedSymbols(AstNode moduleNameNode, @Nullable AstNode aliasNode) {
            String moduleName = moduleNameNode.getChildren(PythonGrammar.NAME).stream().map(AstNode::getTokenValue).collect(Collectors.joining("."));
            if (aliasNode != null) {
                this.currentScope().addWriteUsage(aliasNode);
                String alias = aliasNode.getTokenValue();
                SymbolTableBuilderVisitor.this.importedModules.put(alias, new Module(moduleName, this.currentScope(), alias));
            } else {
                this.currentScope().addWriteUsage(moduleNameNode);
                SymbolTableBuilderVisitor.this.importedModules.put(moduleName, new Module(moduleName, this.currentScope(), null));
            }
        }

        private void visitAssignment(AstNode node) {
            for (AstNode assignOperator : node.getChildren(PythonPunctuator.ASSIGN, PythonGrammar.AUGASSIGN, PythonGrammar.ANNASSIGN)) {
                AstNode target = assignOperator.getPreviousSibling();
                if (assignOperator.is(PythonGrammar.ANNASSIGN)) {
                    assignOperator = assignOperator.getFirstChild(PythonPunctuator.ASSIGN);
                }
                if (assignOperator == null) continue;
                if (this.currentScopeRootTree().is(PythonGrammar.CLASSDEF)) {
                    FirstPhaseVisitor firstPhaseVisitor = new FirstPhaseVisitor();
                    firstPhaseVisitor.enterScope(this.currentScopeRootTree());
                    firstPhaseVisitor.scanNode(assignOperator.getNextSibling());
                    new ClassVariableAssignmentVisitor(this.currentScopeRootTree()).scanNode(assignOperator.getNextSibling());
                }
                if (target.getTokens().size() != 1) continue;
                this.addWriteUsage(target.getFirstDescendant(PythonGrammar.NAME));
            }
        }

        private void createFunctionParameters(AstNode functionTree) {
            AstNode parameters = functionTree.getFirstChild(PythonGrammar.TYPEDARGSLIST);
            if (parameters == null) {
                return;
            }
            AstSelect parameterNames = parameters.select().descendants((AstNodeType)PythonGrammar.TFPDEF).children((AstNodeType)PythonGrammar.NAME);
            for (AstNode parameterName : parameterNames) {
                this.addWriteUsage(parameterName);
            }
        }

        private void createLambdaParameters(AstNode functionTree) {
            AstNode parameters = functionTree.getFirstChild(PythonGrammar.VARARGSLIST);
            if (parameters == null) {
                return;
            }
            parameters.getChildren(PythonGrammar.NAME).forEach(this::addWriteUsage);
            parameters.getDescendants(PythonGrammar.FPDEF).stream().flatMap(paramDef -> paramDef.getChildren(PythonGrammar.NAME).stream()).forEach(this::addWriteUsage);
        }

        private void createLoopVariables(AstNode loopTree) {
            AstNode target = loopTree.getFirstChild(PythonGrammar.EXPRLIST);
            if (target.getTokens().size() == 1) {
                this.addWriteUsage(target.getFirstDescendant(PythonGrammar.NAME));
            }
        }

        private void createScope(AstNode node, @Nullable Scope parent) {
            SymbolTableBuilderVisitor.this.scopesByRootTree.put(node, new Scope(parent, node));
        }

        private void addWriteUsage(AstNode nameNode) {
            this.currentScope().addWriteUsage(nameNode);
        }

        private Scope currentScope() {
            return (Scope)SymbolTableBuilderVisitor.this.scopesByRootTree.get(this.currentScopeRootTree());
        }
    }

    private static class ScopeVisitor
    extends PythonVisitor {
        private Deque<AstNode> scopeRootTrees = new LinkedList<AstNode>();

        private ScopeVisitor() {
        }

        @Override
        public void visitFile(AstNode node) {
            this.enterScope(node);
        }

        public void enterScope(AstNode node) {
            this.scopeRootTrees.push(node);
        }

        @Override
        public void visitNode(AstNode node) {
            if (node.is(PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF, PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND)) {
                this.enterScope(node);
            }
        }

        @Override
        public void leaveNode(AstNode node) {
            if (node.is(PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF, PythonGrammar.LAMBDEF, PythonGrammar.LAMBDEF_NOCOND)) {
                this.scopeRootTrees.pop();
            }
        }

        public AstNode currentScopeRootTree() {
            return this.scopeRootTrees.peek();
        }
    }
}

