/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyAnnotatedAssignmentTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyAnnotatedAssignmentTreeImpl
extends PyTree
implements PyAnnotatedAssignmentTree {
    private final PyExpressionTree variable;
    private final Token colonToken;
    private final PyExpressionTree annotation;
    private final Token equalToken;
    private final PyExpressionTree assignedValue;

    public PyAnnotatedAssignmentTreeImpl(PyExpressionTree variable, Token colonToken, PyExpressionTree annotation, @Nullable Token equalToken, @Nullable PyExpressionTree assignedValue) {
        super(variable.firstToken(), assignedValue != null ? assignedValue.lastToken() : annotation.lastToken());
        this.variable = variable;
        this.colonToken = colonToken;
        this.annotation = annotation;
        this.equalToken = equalToken;
        this.assignedValue = assignedValue;
    }

    @Override
    public PyExpressionTree variable() {
        return this.variable;
    }

    @Override
    public Token colonToken() {
        return this.colonToken;
    }

    @Override
    public PyExpressionTree annotation() {
        return this.annotation;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    @CheckForNull
    public PyExpressionTree assignedValue() {
        return this.assignedValue;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitAnnotatedAssignment(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.variable, this.annotation, this.assignedValue);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ANNOTATED_ASSIGNMENT;
    }
}

