/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyArgumentTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyArgumentTreeImpl
extends PyTree
implements PyArgumentTree {
    private final PyNameTree keywordArgument;
    private final PyExpressionTree expression;
    private final Token equalToken;
    private final Token star;
    private final Token starStar;

    public PyArgumentTreeImpl(AstNode node, PyNameTree keywordArgument, PyExpressionTree expression, Token equalToken, @Nullable AstNode star, @Nullable AstNode starStar) {
        super(node);
        this.keywordArgument = keywordArgument;
        this.expression = expression;
        this.equalToken = equalToken;
        this.star = star != null ? star.getToken() : null;
        this.starStar = starStar != null ? starStar.getToken() : null;
    }

    public PyArgumentTreeImpl(AstNode astNode, PyExpressionTree expression, @Nullable AstNode star, @Nullable AstNode starStar) {
        super(astNode);
        this.keywordArgument = null;
        this.expression = expression;
        this.equalToken = null;
        this.star = star != null ? star.getToken() : null;
        this.starStar = starStar != null ? starStar.getToken() : null;
    }

    @Override
    @CheckForNull
    public PyNameTree keywordArgument() {
        return this.keywordArgument;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    public PyExpressionTree expression() {
        return this.expression;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.star;
    }

    @Override
    @CheckForNull
    public Token starStarToken() {
        return this.starStar;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitArgument(this);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARGUMENT;
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.keywordArgument, this.expression);
    }
}

