/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.python.api.tree.PyBinaryExpressionTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyBinaryExpressionTreeImpl
extends PyTree
implements PyBinaryExpressionTree {
    private static final Map<String, Tree.Kind> KINDS_BY_OPERATOR = PyBinaryExpressionTreeImpl.kindsByOperator();
    private final Tree.Kind kind;
    private final PyExpressionTree leftOperand;
    private final Token operator;
    private final PyExpressionTree rightOperand;

    private static Map<String, Tree.Kind> kindsByOperator() {
        HashMap<String, Tree.Kind> map = new HashMap<String, Tree.Kind>();
        map.put("+", Tree.Kind.PLUS);
        map.put("-", Tree.Kind.MINUS);
        map.put("*", Tree.Kind.MULTIPLICATION);
        map.put("/", Tree.Kind.DIVISION);
        map.put("//", Tree.Kind.FLOOR_DIVISION);
        map.put("%", Tree.Kind.MODULO);
        map.put("**", Tree.Kind.POWER);
        map.put("@", Tree.Kind.MATRIX_MULTIPLICATION);
        map.put(">>", Tree.Kind.SHIFT_EXPR);
        map.put("<<", Tree.Kind.SHIFT_EXPR);
        map.put("&", Tree.Kind.BITWISE_AND);
        map.put("|", Tree.Kind.BITWISE_OR);
        map.put("^", Tree.Kind.BITWISE_XOR);
        map.put("and", Tree.Kind.AND);
        map.put("or", Tree.Kind.OR);
        map.put("==", Tree.Kind.COMPARISON);
        map.put("<=", Tree.Kind.COMPARISON);
        map.put(">=", Tree.Kind.COMPARISON);
        map.put("<", Tree.Kind.COMPARISON);
        map.put(">", Tree.Kind.COMPARISON);
        map.put("!=", Tree.Kind.COMPARISON);
        map.put("<>", Tree.Kind.COMPARISON);
        return map;
    }

    public PyBinaryExpressionTreeImpl(PyExpressionTree leftOperand, Token operator, PyExpressionTree rightOperand) {
        super(leftOperand.firstToken(), rightOperand.lastToken());
        this.kind = KINDS_BY_OPERATOR.get(operator.getValue());
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public PyExpressionTree leftOperand() {
        return this.leftOperand;
    }

    @Override
    public Token operator() {
        return this.operator;
    }

    @Override
    public PyExpressionTree rightOperand() {
        return this.rightOperand;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.leftOperand, this.rightOperand);
    }
}

