/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyArgListTree;
import org.sonar.python.api.tree.PyClassDefTree;
import org.sonar.python.api.tree.PyDecoratorTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyClassDefTreeImpl
extends PyTree
implements PyClassDefTree {
    private final List<PyDecoratorTree> decorators;
    private final Token classKeyword;
    private final PyNameTree name;
    private final Token leftPar;
    private final PyArgListTree args;
    private final Token rightPar;
    private final Token colon;
    private final PyStatementListTree body;
    private final Token docstring;

    public PyClassDefTreeImpl(AstNode astNode, List<PyDecoratorTree> decorators, Token classKeyword, PyNameTree name, @Nullable Token leftPar, @Nullable PyArgListTree args, @Nullable Token rightPar, Token colon, PyStatementListTree body, Token docstring) {
        super(astNode);
        this.decorators = decorators;
        this.classKeyword = classKeyword;
        this.name = name;
        this.leftPar = leftPar;
        this.args = args;
        this.rightPar = rightPar;
        this.colon = colon;
        this.body = body;
        this.docstring = docstring;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CLASSDEF;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitClassDef(this);
    }

    @Override
    public List<PyDecoratorTree> decorators() {
        return this.decorators;
    }

    @Override
    public Token classKeyword() {
        return this.classKeyword;
    }

    @Override
    public PyNameTree name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    @CheckForNull
    public PyArgListTree args() {
        return this.args;
    }

    @Override
    @CheckForNull
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public PyStatementListTree body() {
        return this.body;
    }

    @Override
    @CheckForNull
    public Token docstring() {
        return this.docstring;
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.name, this.args, this.body);
    }
}

