/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExecStatementTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyExecStatementTreeImpl
extends PyTree
implements PyExecStatementTree {
    private final Token execKeyword;
    private final PyExpressionTree expression;
    private final PyExpressionTree globalsExpression;
    private final PyExpressionTree localsExpression;

    public PyExecStatementTreeImpl(AstNode astNode, Token execKeyword, PyExpressionTree expression, @Nullable PyExpressionTree globalsExpression, @Nullable PyExpressionTree localsExpression) {
        super(astNode);
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.globalsExpression = globalsExpression;
        this.localsExpression = localsExpression;
    }

    public PyExecStatementTreeImpl(AstNode astNode, Token execKeyword, PyExpressionTree expression) {
        super(astNode);
        this.execKeyword = execKeyword;
        this.expression = expression;
        this.globalsExpression = null;
        this.localsExpression = null;
    }

    @Override
    public Token execKeyword() {
        return this.execKeyword;
    }

    @Override
    public PyExpressionTree expression() {
        return this.expression;
    }

    @Override
    public PyExpressionTree globalsExpression() {
        return this.globalsExpression;
    }

    @Override
    public PyExpressionTree localsExpression() {
        return this.localsExpression;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.EXEC_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitExecStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.expression, this.globalsExpression, this.localsExpression);
    }
}

