/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyDecoratorTree;
import org.sonar.python.api.tree.PyFunctionDefTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyParameterListTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTypeAnnotationTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyFunctionDefTreeImpl
extends PyTree
implements PyFunctionDefTree {
    private final List<PyDecoratorTree> decorators;
    private final Token asyncKeyword;
    private final Token defKeyword;
    private final PyNameTree name;
    private final Token leftPar;
    private final PyParameterListTree parameters;
    private final Token rightPar;
    private final PyTypeAnnotationTree returnType;
    private final Token colon;
    private final PyStatementListTree body;
    private final boolean isMethodDefinition;
    private final Token docstring;

    public PyFunctionDefTreeImpl(AstNode astNode, List<PyDecoratorTree> decorators, @Nullable Token asyncKeyword, Token defKeyword, PyNameTree name, Token leftPar, @Nullable PyParameterListTree parameters, Token rightPar, @Nullable PyTypeAnnotationTree returnType, Token colon, PyStatementListTree body, boolean isMethodDefinition, @Nullable Token docstring) {
        super(astNode);
        this.decorators = decorators;
        this.asyncKeyword = asyncKeyword;
        this.defKeyword = defKeyword;
        this.name = name;
        this.leftPar = leftPar;
        this.parameters = parameters;
        this.rightPar = rightPar;
        this.returnType = returnType;
        this.colon = colon;
        this.body = body;
        this.isMethodDefinition = isMethodDefinition;
        this.docstring = docstring;
    }

    @Override
    public List<PyDecoratorTree> decorators() {
        return this.decorators;
    }

    @Override
    public Token defKeyword() {
        return this.defKeyword;
    }

    @Override
    @CheckForNull
    public Token asyncKeyword() {
        return this.asyncKeyword;
    }

    @Override
    public PyNameTree name() {
        return this.name;
    }

    @Override
    public Token leftPar() {
        return this.leftPar;
    }

    @Override
    @CheckForNull
    public PyParameterListTree parameters() {
        return this.parameters;
    }

    @Override
    public Token rightPar() {
        return this.rightPar;
    }

    @Override
    @CheckForNull
    public PyTypeAnnotationTree returnTypeAnnotation() {
        return this.returnType;
    }

    @Override
    public Token colon() {
        return this.colon;
    }

    @Override
    public PyStatementListTree body() {
        return this.body;
    }

    @Override
    public boolean isMethodDefinition() {
        return this.isMethodDefinition;
    }

    @Override
    @CheckForNull
    public Token docstring() {
        return this.docstring;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FUNCDEF;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitFunctionDef(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.name, this.parameters, this.body);
    }
}

