/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.PyElseStatementTree;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyIfStatementTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyIfStatementTreeImpl
extends PyTree
implements PyIfStatementTree {
    private final Token keyword;
    private final PyExpressionTree condition;
    private final PyStatementListTree statements;
    private final List<PyIfStatementTree> elifBranches;
    private final boolean isElif;
    @CheckForNull
    private final PyElseStatementTree elseStatement;

    public PyIfStatementTreeImpl(Token ifKeyword, PyExpressionTree condition, PyStatementListTree statements, List<PyIfStatementTree> elifBranches, @CheckForNull PyElseStatementTree elseStatement) {
        super(ifKeyword, statements.lastToken());
        this.keyword = ifKeyword;
        this.condition = condition;
        this.statements = statements;
        this.elifBranches = elifBranches;
        this.isElif = false;
        this.elseStatement = elseStatement;
    }

    public PyIfStatementTreeImpl(Token elifKeyword, PyExpressionTree condition, PyStatementListTree statements) {
        super(elifKeyword, statements.lastToken());
        this.keyword = elifKeyword;
        this.condition = condition;
        this.statements = statements;
        this.elifBranches = Collections.emptyList();
        this.isElif = true;
        this.elseStatement = null;
    }

    @Override
    public Token keyword() {
        return this.keyword;
    }

    @Override
    public PyExpressionTree condition() {
        return this.condition;
    }

    @Override
    public PyStatementListTree body() {
        return this.statements;
    }

    @Override
    public List<PyIfStatementTree> elifBranches() {
        return this.elifBranches;
    }

    @Override
    public boolean isElif() {
        return this.isElif;
    }

    @Override
    @CheckForNull
    public PyElseStatementTree elseBranch() {
        return this.elseStatement;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IF_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.elifBranches, Arrays.asList(this.condition, this.statements, this.elseStatement)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

