/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyParameterTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTypeAnnotationTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyParameterTreeImpl
extends PyTree
implements PyParameterTree {
    private final PyNameTree name;
    private final PyTypeAnnotationTree annotation;
    private final Token equalToken;
    private final PyExpressionTree defaultValue;
    private final Token starToken;

    public PyParameterTreeImpl(AstNode node, @Nullable Token starToken, PyNameTree name, @Nullable PyTypeAnnotationTree annotation, @Nullable Token equalToken, @Nullable PyExpressionTree defaultValue) {
        super(node);
        this.starToken = starToken;
        this.name = name;
        this.annotation = annotation;
        this.equalToken = equalToken;
        this.defaultValue = defaultValue;
    }

    @Override
    @CheckForNull
    public Token starToken() {
        return this.starToken;
    }

    @Override
    public PyNameTree name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public PyTypeAnnotationTree typeAnnotation() {
        return this.annotation;
    }

    @Override
    @CheckForNull
    public Token equalToken() {
        return this.equalToken;
    }

    @Override
    @CheckForNull
    public PyExpressionTree defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARAMETER;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.name, this.annotation, this.defaultValue);
    }
}

