/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyNameTree;
import org.sonar.python.api.tree.PyQualifiedExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyQualifiedExpressionTreeImpl
extends PyTree
implements PyQualifiedExpressionTree {
    private final PyNameTree name;
    private final PyExpressionTree qualifier;
    private final Token dotToken;
    private final AstNode astNode;

    public PyQualifiedExpressionTreeImpl(AstNode astNode, PyNameTree name, PyExpressionTree qualifier, Token dotToken) {
        super(qualifier.firstToken(), name.lastToken());
        this.astNode = astNode;
        this.name = name;
        this.qualifier = qualifier;
        this.dotToken = dotToken;
    }

    @Override
    @CheckForNull
    public AstNode astNode() {
        return this.astNode;
    }

    @Override
    public PyExpressionTree qualifier() {
        return this.qualifier;
    }

    @Override
    public Token dotToken() {
        return this.dotToken;
    }

    @Override
    public PyNameTree name() {
        return this.name;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.QUALIFIED_EXPR;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitQualifiedExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.name, this.qualifier);
    }
}

