/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyElseStatementTree;
import org.sonar.python.api.tree.PyExceptClauseTree;
import org.sonar.python.api.tree.PyFinallyClauseTree;
import org.sonar.python.api.tree.PyStatementListTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTryStatementTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyTryStatementTreeImpl
extends PyTree
implements PyTryStatementTree {
    private final Token tryKeyword;
    private final PyStatementListTree tryBody;
    private final List<PyExceptClauseTree> exceptClauses;
    private final PyFinallyClauseTree finallyClause;
    private final PyElseStatementTree elseStatement;

    public PyTryStatementTreeImpl(AstNode astNode, Token tryKeyword, PyStatementListTree tryBody, List<PyExceptClauseTree> exceptClauses, @Nullable PyFinallyClauseTree finallyClause, @Nullable PyElseStatementTree elseStatement) {
        super(astNode);
        this.tryKeyword = tryKeyword;
        this.tryBody = tryBody;
        this.exceptClauses = exceptClauses;
        this.finallyClause = finallyClause;
        this.elseStatement = elseStatement;
    }

    @Override
    public Token tryKeyword() {
        return this.tryKeyword;
    }

    @Override
    public List<PyExceptClauseTree> exceptClauses() {
        return this.exceptClauses;
    }

    @Override
    @CheckForNull
    public PyFinallyClauseTree finallyClause() {
        return this.finallyClause;
    }

    @Override
    @CheckForNull
    public PyElseStatementTree elseClause() {
        return this.elseStatement;
    }

    @Override
    public PyStatementListTree body() {
        return this.tryBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.TRY_STMT;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitTryStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Stream.of(this.exceptClauses, Arrays.asList(this.tryBody, this.finallyClause, this.elseStatement)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

