/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyTypeAnnotationTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyTypeAnnotationTreeImpl
extends PyTree
implements PyTypeAnnotationTree {
    private final Token dash;
    private final Token gt;
    private final Token colonToken;
    private final PyExpressionTree expression;
    private final Tree.Kind kind;

    public PyTypeAnnotationTreeImpl(Token colonToken, PyExpressionTree expression) {
        super(colonToken, expression.lastToken());
        this.colonToken = colonToken;
        this.dash = null;
        this.gt = null;
        this.expression = expression;
        this.kind = Tree.Kind.TYPE_ANNOTATION;
    }

    public PyTypeAnnotationTreeImpl(Token dash, Token gt, PyExpressionTree expression) {
        super(dash, expression.lastToken());
        this.colonToken = null;
        this.dash = dash;
        this.gt = gt;
        this.expression = expression;
        this.kind = Tree.Kind.RETURN_TYPE_ANNOTATION;
    }

    @Override
    @CheckForNull
    public Token colonToken() {
        return this.colonToken;
    }

    @Override
    @CheckForNull
    public Token dash() {
        return this.dash;
    }

    @Override
    @CheckForNull
    public Token gt() {
        return this.gt;
    }

    @Override
    public PyExpressionTree expression() {
        return this.expression;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitTypeAnnotation(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }
}

