/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.python.api.tree.PyExpressionTree;
import org.sonar.python.api.tree.PyTreeVisitor;
import org.sonar.python.api.tree.PyYieldExpressionTree;
import org.sonar.python.api.tree.Tree;
import org.sonar.python.tree.PyTree;

public class PyYieldExpressionTreeImpl
extends PyTree
implements PyYieldExpressionTree {
    private final Token yieldKeyword;
    private final Token fromKeyword;
    private final List<PyExpressionTree> expressionTrees;

    public PyYieldExpressionTreeImpl(AstNode astNode, Token yieldKeyword, @Nullable Token fromKeyword, List<PyExpressionTree> expressionTrees) {
        super(astNode);
        this.yieldKeyword = yieldKeyword;
        this.fromKeyword = fromKeyword;
        this.expressionTrees = expressionTrees;
    }

    @Override
    public Token yieldKeyword() {
        return this.yieldKeyword;
    }

    @Override
    @CheckForNull
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    public List<PyExpressionTree> expressions() {
        return this.expressionTrees;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.YIELD_EXPR;
    }

    @Override
    public void accept(PyTreeVisitor visitor) {
        visitor.visitYieldExpression(this);
    }

    @Override
    public List<Tree> children() {
        return Collections.unmodifiableList(this.expressionTrees);
    }
}

