/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.python.checks.CheckList;

public final class PythonSensor
implements Sensor {
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories) {
        this.checks = new PythonChecks(checkFactory).addChecks("python", CheckList.getChecks()).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("py").name("Python Sensor").onlyOnFileType(InputFile.Type.MAIN);
    }

    public void execute(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        ArrayList list = new ArrayList();
        it.forEach(list::add);
        List<InputFile> inputFiles = Collections.unmodifiableList(list);
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, inputFiles);
        scanner.scanFiles();
    }
}

