/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.cfg.fixpoint;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.python.cfg.fixpoint.CfgBlockState;
import org.sonar.python.cfg.fixpoint.UsageVisitor;

public class LiveVariablesAnalysis {
    private final Map<CfgBlock, LiveVariables> liveVariablesPerBlock = new HashMap<CfgBlock, LiveVariables>();

    public static LiveVariablesAnalysis analyze(ControlFlowGraph cfg) {
        LiveVariablesAnalysis instance = new LiveVariablesAnalysis();
        instance.compute(cfg);
        return instance;
    }

    private void compute(ControlFlowGraph cfg) {
        cfg.blocks().forEach(block -> this.liveVariablesPerBlock.put((CfgBlock)block, LiveVariables.build(block)));
        ArrayDeque<CfgBlock> workList = new ArrayDeque<CfgBlock>(cfg.blocks());
        while (!workList.isEmpty()) {
            CfgBlock currentBlock = (CfgBlock)workList.pop();
            LiveVariables liveVariables = this.liveVariablesPerBlock.get(currentBlock);
            boolean liveInHasChanged = liveVariables.propagate(this.liveVariablesPerBlock);
            if (!liveInHasChanged) continue;
            currentBlock.predecessors().forEach(workList::push);
        }
    }

    public LiveVariables getLiveVariables(CfgBlock block) {
        return this.liveVariablesPerBlock.get(block);
    }

    public Set<Symbol> getReadSymbols() {
        HashSet<Symbol> readAtLeastOnce = new HashSet<Symbol>();
        for (LiveVariables liveVariables : this.liveVariablesPerBlock.values()) {
            for (Map symbolVariableUsageMap : liveVariables.variableUsagesPerElement.values()) {
                for (Map.Entry symbolWithUsage : symbolVariableUsageMap.entrySet()) {
                    if (!((UsageVisitor.SymbolUsage)symbolWithUsage.getValue()).isRead()) continue;
                    readAtLeastOnce.add((Symbol)symbolWithUsage.getKey());
                }
            }
        }
        return readAtLeastOnce;
    }

    public static class LiveVariables
    extends CfgBlockState {
        private Set<Symbol> in = new HashSet<Symbol>();
        private Set<Symbol> out = new HashSet<Symbol>();

        private LiveVariables(CfgBlock block) {
            super(block);
        }

        public static LiveVariables build(CfgBlock block) {
            LiveVariables instance = new LiveVariables(block);
            instance.init(block);
            return instance;
        }

        private boolean propagate(Map<CfgBlock, LiveVariables> liveVariablesPerBlock) {
            this.out.clear();
            this.block.successors().stream().map(liveVariablesPerBlock::get).map(LiveVariables::getIn).forEach(this.out::addAll);
            HashSet<Symbol> newIn = new HashSet<Symbol>(this.gen);
            newIn.addAll(LiveVariables.difference(this.out, this.kill));
            boolean inHasChanged = !newIn.equals(this.in);
            this.in = newIn;
            return inHasChanged;
        }

        private static Set<Symbol> difference(Set<Symbol> out, Set<Symbol> kill) {
            HashSet<Symbol> result = new HashSet<Symbol>(out);
            result.removeIf(kill::contains);
            return result;
        }

        public Set<Symbol> getIn() {
            return this.in;
        }

        public Set<Symbol> getOut() {
            return this.out;
        }
    }
}

