/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashMap;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.CfgUtils;
import org.sonar.python.cfg.fixpoint.DefinedVariablesAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S3827")
public class UndeclaredNameUsageCheck
extends PythonSubscriptionCheck {
    private boolean hasWildcardImport = false;
    private boolean callGlobalsOrLocals = false;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            FileInput fileInput = (FileInput)ctx.syntaxNode();
            ExceptionVisitor exceptionVisitor = new ExceptionVisitor();
            fileInput.accept(exceptionVisitor);
            this.hasWildcardImport = exceptionVisitor.hasWildcardImport;
            this.callGlobalsOrLocals = exceptionVisitor.callGlobalsOrLocals;
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.NAME, ctx -> {
            Name name = (Name)ctx.syntaxNode();
            if (!this.callGlobalsOrLocals && !this.hasWildcardImport && name.isVariable() && name.symbol() == null) {
                ctx.addIssue(name, name.name() + " is not defined. Change its name or define it before using it");
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (TreeUtils.hasDescendant(functionDef, tree -> tree.is(Tree.Kind.TRY_STMT))) {
                return;
            }
            ControlFlowGraph cfg = ControlFlowGraph.build(functionDef, ctx.pythonFile());
            if (cfg == null) {
                return;
            }
            DefinedVariablesAnalysis analysis = DefinedVariablesAnalysis.analyze(cfg, functionDef.localVariables());
            Set<CfgBlock> unreachableBlocks = CfgUtils.unreachableBlocks(cfg);
            cfg.blocks().forEach(block -> UndeclaredNameUsageCheck.checkCfgBlock(block, ctx, analysis.getDefinedVariables((CfgBlock)block), unreachableBlocks, analysis));
        });
    }

    private static void checkCfgBlock(CfgBlock cfgBlock, SubscriptionContext ctx, DefinedVariablesAnalysis.DefinedVariables definedVariables, Set<CfgBlock> unreachableBlocks, DefinedVariablesAnalysis analysis) {
        HashMap<Symbol, DefinedVariablesAnalysis.VariableDefinition> currentState = new HashMap<Symbol, DefinedVariablesAnalysis.VariableDefinition>(definedVariables.getIn());
        for (Tree element : cfgBlock.elements()) {
            definedVariables.getVariableUsages(element).forEach((symbol, symbolUsage) -> {
                if (symbolUsage.isWrite()) {
                    currentState.put((Symbol)symbol, DefinedVariablesAnalysis.VariableDefinition.DEFINED);
                }
                DefinedVariablesAnalysis.VariableDefinition varDef = currentState.getOrDefault(symbol, DefinedVariablesAnalysis.VariableDefinition.DEFINED);
                if (symbolUsage.isRead() && UndeclaredNameUsageCheck.isUndefined(varDef) && !UndeclaredNameUsageCheck.isSymbolUsedInUnreachableBlocks(analysis, unreachableBlocks, symbol) && !UndeclaredNameUsageCheck.isParameter(element)) {
                    ctx.addIssue(element, symbol.name() + " is used before it is defined. Move the definition before.");
                }
            });
        }
    }

    private static boolean isParameter(Tree element) {
        return element.is(Tree.Kind.PARAMETER);
    }

    private static boolean isSymbolUsedInUnreachableBlocks(DefinedVariablesAnalysis analysis, Set<CfgBlock> unreachableBlocks, Symbol symbol) {
        return unreachableBlocks.stream().anyMatch(b -> analysis.getDefinedVariables((CfgBlock)b).isSymbolUsedInBlock(symbol));
    }

    private static boolean isUndefined(DefinedVariablesAnalysis.VariableDefinition varDef) {
        return varDef == DefinedVariablesAnalysis.VariableDefinition.UNDEFINED;
    }

    private static class ExceptionVisitor
    extends BaseTreeVisitor {
        private boolean hasWildcardImport = false;
        private boolean callGlobalsOrLocals = false;

        private ExceptionVisitor() {
        }

        @Override
        public void visitImportFrom(ImportFrom importFrom) {
            this.hasWildcardImport |= importFrom.isWildcardImport();
            super.visitImportFrom(importFrom);
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            if (callExpression.callee().is(Tree.Kind.NAME)) {
                String name = ((Name)callExpression.callee()).name();
                this.callGlobalsOrLocals |= name.equals("globals") || name.equals("locals");
            }
            super.visitCallExpression(callExpression);
        }
    }
}

