/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;

@Rule(key="S5332")
public class ClearTextProtocolsCheck
extends PythonSubscriptionCheck {
    private static final List<String> SENSITIVE_PROTOCOLS = Arrays.asList("http://", "ftp://", "telnet://");
    private static final Pattern LOOPBACK = Pattern.compile("localhost|127(?:\\.[0-9]+){0,2}\\.[0-9]+$|^(?:0*\\:)*?:?0*1", 2);
    private static final Map<String, String> ALTERNATIVES = new HashMap<String, String>();

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_ELEMENT, ctx -> {
            Tree node = ctx.syntaxNode();
            String value = Expressions.unescape((StringElement)node);
            ClearTextProtocolsCheck.unsafeProtocol(value).map(protocol -> protocol.substring(0, protocol.length() - 3)).ifPresent(protocol -> ctx.addIssue(node, ClearTextProtocolsCheck.message(protocol)));
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            Symbol symbol = ((CallExpression)ctx.syntaxNode()).calleeSymbol();
            ClearTextProtocolsCheck.isUnsafeLib(symbol).ifPresent(protocol -> ctx.addIssue(ctx.syntaxNode(), ClearTextProtocolsCheck.message(protocol)));
        });
    }

    private static Optional<String> unsafeProtocol(String literalValue) {
        for (String protocol : SENSITIVE_PROTOCOLS) {
            block5: {
                if (!literalValue.startsWith(protocol)) continue;
                try {
                    URI uri = new URI(literalValue);
                    String host = uri.getHost();
                    if (host == null) {
                        host = uri.getAuthority();
                    }
                    if (host == null || LOOPBACK.matcher(host).matches()) {
                        return Optional.empty();
                    }
                }
                catch (URISyntaxException e) {
                    if (!LOOPBACK.matcher(literalValue.substring(protocol.length())).find()) break block5;
                    return Optional.empty();
                }
            }
            return Optional.of(protocol);
        }
        return Optional.empty();
    }

    private static Optional<String> isUnsafeLib(@Nullable Symbol symbol) {
        if (symbol != null) {
            String qualifiedName = symbol.fullyQualifiedName();
            if ("telnetlib.Telnet".equals(qualifiedName)) {
                return Optional.of("telnet");
            }
            if ("ftplib.FTP".equals(qualifiedName)) {
                return Optional.of("ftp");
            }
        }
        return Optional.empty();
    }

    private static String message(String protocol) {
        return "Using " + protocol + " protocol is insecure. Use " + ALTERNATIVES.get(protocol) + " instead";
    }

    static {
        ALTERNATIVES.put("http", "https");
        ALTERNATIVES.put("ftp", "sftp, scp or ftps");
        ALTERNATIVES.put("telnet", "ssh");
    }
}

