/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;

public class PylintRuleRepository
implements RulesDefinition {
    public static final String REPOSITORY_NAME = "Pylint";
    public static final String REPOSITORY_KEY = "Pylint";
    public static final String RULES_FILE = "/org/sonar/plugins/python/pylint/rules.xml";
    private static final String REMEDIATION_FILE = "/org/sonar/plugins/python/pylint/remediation-cost.csv";
    private final RulesDefinitionXmlLoader xmlLoader;

    public PylintRuleRepository(RulesDefinitionXmlLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository("Pylint", "py").setName("Pylint");
        this.xmlLoader.load(repository, this.getClass().getResourceAsStream(RULES_FILE), StandardCharsets.UTF_8.name());
        PylintRuleRepository.defineRemediationFunction(repository);
        repository.done();
    }

    private static void defineRemediationFunction(RulesDefinition.NewRepository repository) {
        Map<String, String> remediationCostMap = PylintRuleRepository.loadRemediationCostMap();
        for (RulesDefinition.NewRule rule : repository.rules()) {
            String gap = remediationCostMap.get(rule.key());
            if (gap == null) {
                throw new IllegalStateException("Missing remediation cost for rule " + rule.key());
            }
            if (gap.equals("null")) continue;
            rule.setDebtRemediationFunction(rule.debtRemediationFunctions().linear(gap));
        }
    }

    private static Map<String, String> loadRemediationCostMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(PylintRuleRepository.class.getResourceAsStream(REMEDIATION_FILE), StandardCharsets.UTF_8.name());){
            while (scanner.hasNext()) {
                String[] cols = scanner.next().split(",");
                map.put(cols[0], cols[1]);
            }
        }
        return map;
    }
}

