/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="S930")
public class ArgumentNumberCheck
extends PythonSubscriptionCheck {
    private static final String FUNCTION_DEFINITION = "Function definition.";

    private static String message(String functionName, long minRequiredPositionalArguments, int nArguments, long nPositionalParamWithDefaultValue) {
        String message = "";
        message = minRequiredPositionalArguments > (long)nArguments ? "Add " + (minRequiredPositionalArguments - (long)nArguments) + " missing arguments; " : "Remove " + ((long)nArguments - minRequiredPositionalArguments - nPositionalParamWithDefaultValue) + " unexpected arguments; ";
        return message + "'" + functionName + "' expects " + minRequiredPositionalArguments + " positional arguments.";
    }

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol symbol = callExpression.calleeSymbol();
            if (symbol != null && symbol.kind() == Symbol.Kind.FUNCTION) {
                long minRequiredPositionalArguments;
                FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                if (functionSymbol.hasDecorators() || functionSymbol.hasVariadicParameter() || callExpression.arguments().stream().anyMatch(argument -> argument.is(Tree.Kind.UNPACKING_EXPR))) {
                    return;
                }
                int nArguments = callExpression.arguments().size();
                if ((long)nArguments < (minRequiredPositionalArguments = functionSymbol.parameters().stream().filter(parameterName -> !parameterName.isKeywordOnly() && !parameterName.hasDefaultValue()).count()) || nArguments > functionSymbol.parameters().size()) {
                    ctx.addIssue(callExpression.callee(), ArgumentNumberCheck.message(functionSymbol.name(), minRequiredPositionalArguments, nArguments, (long)functionSymbol.parameters().size() - minRequiredPositionalArguments)).secondary(functionSymbol.definitionLocation(), FUNCTION_DEFINITION);
                }
                ArgumentNumberCheck.checkKeywordArguments(ctx, callExpression, functionSymbol, callExpression.callee());
            }
        });
    }

    private static void checkKeywordArguments(SubscriptionContext ctx, CallExpression callExpression, FunctionSymbol functionSymbol, Expression callee) {
        List<FunctionSymbol.Parameter> parameters = functionSymbol.parameters();
        Set mandatoryParamNamesKeywordOnly = parameters.stream().filter(parameterName -> parameterName.isKeywordOnly() && !parameterName.hasDefaultValue()).map(FunctionSymbol.Parameter::name).collect(Collectors.toSet());
        for (Argument argument : callExpression.arguments()) {
            RegularArgument arg = (RegularArgument)argument;
            Name keyword = arg.keywordArgument();
            if (keyword == null) continue;
            if (parameters.stream().noneMatch(parameter -> keyword.name().equals(parameter.name()))) {
                ctx.addIssue(argument, "Remove this unexpected named argument '" + keyword.name() + "'.").secondary(functionSymbol.definitionLocation(), FUNCTION_DEFINITION);
                continue;
            }
            mandatoryParamNamesKeywordOnly.remove(keyword.name());
        }
        if (!mandatoryParamNamesKeywordOnly.isEmpty()) {
            StringBuilder message = new StringBuilder("Add the missing keyword arguments: ");
            for (String param : mandatoryParamNamesKeywordOnly) {
                message.append("'").append(param).append("' ");
            }
            ctx.addIssue(callee, message.toString().trim()).secondary(functionSymbol.definitionLocation(), FUNCTION_DEFINITION);
        }
    }
}

