/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.BuiltinSymbols;

@Rule(key="S5632")
public class IncorrectExceptionTypeCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Change this code so that it raises an object deriving from BaseException.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            Symbol symbol;
            CallExpression callExpression;
            Symbol calleeSymbol;
            RaiseStatement raiseStatement = (RaiseStatement)ctx.syntaxNode();
            if (raiseStatement.expressions().isEmpty()) {
                return;
            }
            if (raiseStatement.expressions().get(0).is(Tree.Kind.CALL_EXPR) && !IncorrectExceptionTypeCheck.inheritsFromBaseException(calleeSymbol = (callExpression = (CallExpression)raiseStatement.expressions().get(0)).calleeSymbol())) {
                ctx.addIssue(raiseStatement, MESSAGE);
            }
            if (raiseStatement.expressions().get(0).is(Tree.Kind.NAME) && !IncorrectExceptionTypeCheck.inheritsFromBaseException(symbol = ((Name)raiseStatement.expressions().get(0)).symbol())) {
                ctx.addIssue(raiseStatement, MESSAGE);
            }
            if (raiseStatement.expressions().get(0).is(Tree.Kind.STRING_LITERAL)) {
                ctx.addIssue(raiseStatement, MESSAGE);
            }
        });
    }

    private static boolean inheritsFromBaseException(@Nullable Symbol symbol) {
        if (symbol == null) {
            return true;
        }
        if (BuiltinSymbols.EXCEPTIONS.contains(symbol.fullyQualifiedName()) || BuiltinSymbols.EXCEPTIONS_PYTHON2.contains(symbol.fullyQualifiedName())) {
            return true;
        }
        if (Symbol.Kind.CLASS.equals((Object)symbol.kind())) {
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            if (classSymbol.hasUnresolvedTypeHierarchy()) {
                return true;
            }
            for (Symbol parent : classSymbol.superClasses()) {
                if (!IncorrectExceptionTypeCheck.inheritsFromBaseException(parent)) continue;
                return true;
            }
            return false;
        }
        return !BuiltinSymbols.all().contains(symbol.fullyQualifiedName());
    }
}

