/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.cfg.ControlFlowGraph;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.checks.CheckUtils;
import org.sonar.python.tree.DictCompExpressionImpl;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S2190")
public class InfiniteRecursionCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Add a way to break out of this %s's recursion.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
            if (functionDef.asyncKeyword() != null) {
                return;
            }
            ArrayList<Tree> allRecursiveCalls = new ArrayList<Tree>();
            boolean endBlockIsReachable = InfiniteRecursionCheck.collectRecursiveCallsAndCheckIfEndBlockIsReachable(functionDef, ctx.pythonFile(), allRecursiveCalls);
            if (!allRecursiveCalls.isEmpty() && !endBlockIsReachable) {
                String message = String.format(MESSAGE, functionDef.isMethodDefinition() ? "method" : "function");
                PythonCheck.PreciseIssue issue = ctx.addIssue(functionDef.name(), message);
                allRecursiveCalls.forEach(call -> issue.secondary((Tree)call, "recursive call"));
            }
        });
    }

    private static boolean collectRecursiveCallsAndCheckIfEndBlockIsReachable(FunctionDef functionDef, PythonFile pythonFile, List<Tree> allRecursiveCalls) {
        Symbol functionSymbol = functionDef.name().symbol();
        if (functionSymbol == null) {
            return true;
        }
        ControlFlowGraph cfg = ControlFlowGraph.build(functionDef, pythonFile);
        if (cfg == null) {
            return true;
        }
        RecursiveCallCollector recursiveCallCollector = new RecursiveCallCollector(functionDef, functionSymbol);
        HashSet<CfgBlock> pushedBlocks = new HashSet<CfgBlock>();
        ArrayDeque<CfgBlock> blockToVisit = new ArrayDeque<CfgBlock>();
        blockToVisit.addLast(cfg.start());
        pushedBlocks.add(cfg.start());
        while (!blockToVisit.isEmpty()) {
            CfgBlock block = (CfgBlock)blockToVisit.removeFirst();
            if (block == cfg.end()) {
                return true;
            }
            List blockRecursiveCalls = recursiveCallCollector.findRecursiveCalls(block.elements());
            if (!blockRecursiveCalls.isEmpty()) {
                allRecursiveCalls.addAll(blockRecursiveCalls.stream().filter(tree -> !InfiniteRecursionCheck.isInsideTryBlock(tree)).collect(Collectors.toList()));
                continue;
            }
            block.successors().stream().filter(pushedBlocks::add).forEach(blockToVisit::addLast);
        }
        return recursiveCallCollector.functionSymbolHasBeenReassigned;
    }

    private static boolean isInsideTryBlock(Tree tree) {
        Tree ancestor = TreeUtils.firstAncestorOfKind(tree, Tree.Kind.FINALLY_CLAUSE, Tree.Kind.TRY_STMT);
        return ancestor != null && ancestor.is(Tree.Kind.TRY_STMT);
    }

    private static class RecursiveCallCollector
    extends BaseTreeVisitor {
        private final boolean isMethod;
        private final Symbol functionSymbol;
        @Nullable
        private final Symbol selfSymbol;
        @Nullable
        private final String className;
        private boolean functionSymbolHasBeenReassigned = false;
        private final List<Tree> recursiveCalls = new ArrayList<Tree>();

        private RecursiveCallCollector(FunctionDef currentFunction, Symbol functionSymbol) {
            this.isMethod = currentFunction.isMethodDefinition();
            this.functionSymbol = functionSymbol;
            if (this.isMethod) {
                boolean isStatic = currentFunction.decorators().stream().map(Decorator::name).map(DottedName::names).map(d -> (Name)d.get(d.size() - 1)).map(Name::name).anyMatch(decorator -> decorator.equals("staticmethod") || decorator.equals("classmethod"));
                if (isStatic) {
                    this.selfSymbol = null;
                    this.className = RecursiveCallCollector.findParentClassName(currentFunction);
                } else {
                    this.selfSymbol = RecursiveCallCollector.findSelfParameterSymbol(currentFunction);
                    this.className = null;
                }
            } else {
                this.selfSymbol = null;
                this.className = null;
            }
        }

        private List<Tree> findRecursiveCalls(List<Tree> elements) {
            this.recursiveCalls.clear();
            elements.forEach(element -> element.accept(this));
            return this.recursiveCalls;
        }

        @Override
        public void visitCallExpression(CallExpression callExpression) {
            Expression callee = callExpression.callee();
            if (this.matchesLookupFunction(callee) || this.matchesLookupMethod(callee)) {
                this.recursiveCalls.add(callee);
            }
            super.visitCallExpression(callExpression);
        }

        @Override
        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        }

        @Override
        public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
        }

        @Override
        public void visitConditionalExpression(ConditionalExpression pyConditionalExpressionTree) {
            this.scan(pyConditionalExpressionTree.condition());
        }

        @Override
        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            this.scan(tree.comprehensionFor());
        }

        @Override
        public void visitComprehensionIf(ComprehensionIf tree) {
        }

        @Override
        public void visitDictCompExpression(DictCompExpressionImpl tree) {
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement assignment) {
            if (this.isMethod && assignment.lhsExpressions().stream().map(ExpressionList::expressions).flatMap(Collection::stream).anyMatch(expression -> this.matchesLookupSelf((Expression)expression) || this.matchesLookupMethod((Expression)expression))) {
                this.functionSymbolHasBeenReassigned = true;
            }
            super.visitAssignmentStatement(assignment);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
            this.scan(pyBinaryExpressionTree.leftOperand());
            String operator = pyBinaryExpressionTree.operator().value();
            if (!PythonKeyword.OR.getValue().equals(operator) && !PythonKeyword.AND.getValue().equals(operator)) {
                this.scan(pyBinaryExpressionTree.rightOperand());
            }
        }

        private boolean matchesLookupFunction(Expression expression) {
            if (!expression.is(Tree.Kind.NAME)) {
                return false;
            }
            Name name = (Name)expression;
            return !this.isMethod && this.functionSymbol.equals(name.symbol()) && this.functionSymbol.usages().stream().filter(Usage::isBindingUsage).count() < 2L;
        }

        private boolean matchesLookupMethod(Expression expression) {
            if (!expression.is(Tree.Kind.QUALIFIED_EXPR)) {
                return false;
            }
            QualifiedExpression qualifiedExpression = (QualifiedExpression)expression;
            if (!this.isMethod || !this.functionSymbol.name().equals(qualifiedExpression.name().name())) {
                return false;
            }
            Expression qualifier = qualifiedExpression.qualifier();
            return this.matchesLookupSelf(qualifier) || this.matchesLookupClassName(qualifier);
        }

        private boolean matchesLookupSelf(Expression expression) {
            if (this.selfSymbol == null || !expression.is(Tree.Kind.NAME)) {
                return false;
            }
            return this.selfSymbol.equals(((Name)expression).symbol());
        }

        private boolean matchesLookupClassName(Expression expression) {
            if (this.className == null || !expression.is(Tree.Kind.NAME)) {
                return false;
            }
            return this.className.equals(((Name)expression).name());
        }

        @CheckForNull
        private static Symbol findSelfParameterSymbol(FunctionDef functionDef) {
            ParameterList parameters = functionDef.parameters();
            if (parameters == null) {
                return null;
            }
            List<Parameter> params = parameters.nonTuple();
            if (params.isEmpty()) {
                return null;
            }
            Name firstParameterName = params.get(0).name();
            return firstParameterName != null ? firstParameterName.symbol() : null;
        }

        @CheckForNull
        private static String findParentClassName(FunctionDef functionDef) {
            ClassDef parentClass = CheckUtils.getParentClassDef(functionDef);
            if (parentClass != null) {
                String className = parentClass.name().name();
                boolean conflictsWithLocalVariable = functionDef.localVariables().stream().map(Symbol::name).anyMatch(className::equals);
                if (!conflictsWithLocalVariable) {
                    return className;
                }
            }
            return null;
        }
    }
}

