/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SelfSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;

class Scope {
    final Tree rootTree;
    private PythonFile pythonFile;
    private final Scope parent;
    private final Map<String, Symbol> symbolsByName = new HashMap<String, Symbol>();
    private final Set<Symbol> symbols = new HashSet<Symbol>();
    final Set<Symbol> builtinSymbols = new HashSet<Symbol>();
    private final Set<String> globalNames = new HashSet<String>();
    private final Set<String> nonlocalNames = new HashSet<String>();
    final Map<String, SymbolImpl> instanceAttributesByName = new HashMap<String, SymbolImpl>();

    Scope(@Nullable Scope parent, Tree rootTree, PythonFile pythonFile) {
        this.parent = parent;
        this.rootTree = rootTree;
        this.pythonFile = pythonFile;
    }

    Set<Symbol> symbols() {
        return Collections.unmodifiableSet(this.symbols);
    }

    void createBuiltinSymbol(String name) {
        SymbolImpl symbol = new SymbolImpl(name, name);
        this.symbols.add(symbol);
        this.builtinSymbols.add(symbol);
        this.symbolsByName.put(name, symbol);
    }

    void createSymbolsFromWildcardImport(Set<Symbol> importedSymbols) {
        importedSymbols.forEach(symbol -> {
            Symbol importedSymbol = Scope.copySymbol(symbol.name(), symbol);
            this.symbols.add(importedSymbol);
            this.symbolsByName.put(symbol.name(), importedSymbol);
        });
    }

    void createSelfParameter(Parameter parameter) {
        Name nameTree = parameter.name();
        if (nameTree != null) {
            String symbolName = nameTree.name();
            SelfSymbolImpl symbol = new SelfSymbolImpl(symbolName, this.parent);
            this.symbols.add(symbol);
            this.symbolsByName.put(symbolName, symbol);
            symbol.addUsage(nameTree, Usage.Kind.PARAMETER);
        }
    }

    void addFunctionSymbol(FunctionDef functionDef, @Nullable String fullyQualifiedName) {
        String symbolName = functionDef.name().name();
        if (this.isExistingSymbol(symbolName)) {
            this.addBindingUsage(functionDef.name(), Usage.Kind.FUNC_DECLARATION, fullyQualifiedName);
        } else {
            FunctionSymbolImpl functionSymbol = new FunctionSymbolImpl(functionDef, fullyQualifiedName, this.pythonFile);
            this.symbols.add(functionSymbol);
            this.symbolsByName.put(symbolName, functionSymbol);
            functionSymbol.addUsage(functionDef.name(), Usage.Kind.FUNC_DECLARATION);
        }
    }

    private static Symbol copySymbol(String symbolName, Symbol symbol) {
        if (symbol.kind() == Symbol.Kind.FUNCTION) {
            return new FunctionSymbolImpl(symbolName, (FunctionSymbol)symbol);
        }
        if (symbol.kind() == Symbol.Kind.CLASS) {
            ClassSymbolImpl classSymbol = new ClassSymbolImpl(symbolName, symbol.fullyQualifiedName());
            ((ClassSymbol)symbol).superClasses().forEach(classSymbol::addSuperClass);
            classSymbol.setHasUnresolvedTypeHierarchy(((ClassSymbol)symbol).hasUnresolvedTypeHierarchy());
            return classSymbol;
        }
        return new SymbolImpl(symbolName, symbol.fullyQualifiedName());
    }

    void addModuleSymbol(Name nameTree, @CheckForNull String fullyQualifiedName, Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        String symbolName = nameTree.name();
        Set<Symbol> moduleExportedSymbols = globalSymbolsByModuleName.get(fullyQualifiedName);
        if (moduleExportedSymbols != null && !this.isExistingSymbol(symbolName)) {
            SymbolImpl moduleSymbol = new SymbolImpl(symbolName, fullyQualifiedName);
            moduleExportedSymbols.forEach(symbol -> moduleSymbol.addChildSymbol(Scope.copySymbol(symbol.name(), symbol)));
            this.symbols.add(moduleSymbol);
            this.symbolsByName.put(symbolName, moduleSymbol);
        }
        this.addBindingUsage(nameTree, Usage.Kind.IMPORT, fullyQualifiedName);
    }

    void addImportedSymbol(Name nameTree, @CheckForNull String fullyQualifiedName, Map<String, Symbol> globalSymbolsByFQN) {
        String symbolName = nameTree.name();
        Symbol globalSymbol = globalSymbolsByFQN.get(fullyQualifiedName);
        if (globalSymbol == null || this.isExistingSymbol(symbolName)) {
            this.addBindingUsage(nameTree, Usage.Kind.IMPORT, fullyQualifiedName);
        } else {
            Symbol symbol = Scope.copySymbol(symbolName, globalSymbol);
            this.symbols.add(symbol);
            this.symbolsByName.put(symbolName, symbol);
            ((SymbolImpl)symbol).addUsage(nameTree, Usage.Kind.IMPORT);
        }
    }

    private boolean isExistingSymbol(String symbolName) {
        return this.symbolsByName.containsKey(symbolName) || this.globalNames.contains(symbolName) || this.nonlocalNames.contains(symbolName);
    }

    void addBindingUsage(Name nameTree, Usage.Kind kind, @Nullable String fullyQualifiedName) {
        SymbolImpl symbol;
        String symbolName = nameTree.name();
        if (!this.isExistingSymbol(symbolName)) {
            symbol = new SymbolImpl(symbolName, fullyQualifiedName);
            this.symbols.add(symbol);
            this.symbolsByName.put(symbolName, symbol);
        }
        if ((symbol = this.resolve(symbolName)) != null) {
            if (!Symbol.Kind.OTHER.equals((Object)symbol.kind())) {
                symbol.setKind(Symbol.Kind.OTHER);
            }
            if (fullyQualifiedName != null && !fullyQualifiedName.equals(symbol.fullyQualifiedName)) {
                symbol.fullyQualifiedName = null;
            }
            if (fullyQualifiedName == null && symbol.fullyQualifiedName != null) {
                symbol.fullyQualifiedName = null;
            }
            symbol.addUsage(nameTree, kind);
        }
    }

    @CheckForNull
    SymbolImpl resolve(String symbolName) {
        Symbol symbol = this.symbolsByName.get(symbolName);
        if (this.parent == null || symbol != null) {
            return (SymbolImpl)symbol;
        }
        if (this.parent.rootTree.is(Tree.Kind.CLASSDEF)) {
            return this.parent.parent.resolve(symbolName);
        }
        return this.parent.resolve(symbolName);
    }

    void addGlobalName(String name) {
        this.globalNames.add(name);
    }

    void addNonLocalName(String name) {
        this.nonlocalNames.add(name);
    }

    void addClassSymbol(ClassDef classDef, @Nullable String fullyQualifiedName) {
        String symbolName = classDef.name().name();
        if (this.isExistingSymbol(symbolName)) {
            this.addBindingUsage(classDef.name(), Usage.Kind.CLASS_DECLARATION, fullyQualifiedName);
        } else {
            ClassSymbolImpl classSymbol = new ClassSymbolImpl(symbolName, fullyQualifiedName);
            this.symbols.add(classSymbol);
            this.symbolsByName.put(symbolName, classSymbol);
            classSymbol.addUsage(classDef.name(), Usage.Kind.CLASS_DECLARATION);
        }
    }
}

