/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.tree.Separators;
import org.sonar.python.tree.SimpleStatement;

public class ImportFromImpl
extends SimpleStatement
implements ImportFrom {
    private final Token fromKeyword;
    private final List<Token> dottedPrefixForModule;
    private final DottedName moduleName;
    private final Token importKeyword;
    private final List<AliasedName> aliasedImportNames;
    private final boolean isWildcardImport;
    private final Token wildcard;
    private final Separators separators;
    private boolean hasUnresolvedWildcardImport = false;

    public ImportFromImpl(Token fromKeyword, @Nullable List<Token> dottedPrefixForModule, @Nullable DottedName moduleName, Token importKeyword, @Nullable List<AliasedName> aliasedImportNames, @Nullable Token wildcard, Separators separators) {
        this.fromKeyword = fromKeyword;
        this.dottedPrefixForModule = dottedPrefixForModule;
        this.moduleName = moduleName;
        this.importKeyword = importKeyword;
        this.aliasedImportNames = aliasedImportNames == null ? Collections.emptyList() : aliasedImportNames;
        this.wildcard = wildcard;
        this.isWildcardImport = wildcard != null;
        this.separators = separators;
    }

    @Override
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    @CheckForNull
    public DottedName module() {
        return this.moduleName;
    }

    @Override
    public Token importKeyword() {
        return this.importKeyword;
    }

    @Override
    @CheckForNull
    public List<Token> dottedPrefixForModule() {
        return this.dottedPrefixForModule;
    }

    @Override
    public List<AliasedName> importedNames() {
        return this.aliasedImportNames;
    }

    @Override
    public boolean isWildcardImport() {
        return this.isWildcardImport;
    }

    @Override
    @CheckForNull
    public Token wildcard() {
        return this.wildcard;
    }

    @Override
    public boolean hasUnresolvedWildcardImport() {
        return this.hasUnresolvedWildcardImport;
    }

    public void setHasUnresolvedWildcardImport(boolean hasUnresolvedWildcardImport) {
        this.hasUnresolvedWildcardImport = hasUnresolvedWildcardImport;
    }

    @Override
    @CheckForNull
    public Token separator() {
        return this.separators.last();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_FROM;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitImportFrom(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Collections.singletonList(this.fromKeyword), this.dottedPrefixForModule, Arrays.asList(this.moduleName, this.importKeyword), this.aliasedImportNames, Collections.singletonList(this.wildcard), this.separators.elements()).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

