/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.InExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.BinaryExpressionImpl;

public class InExpressionImpl
extends BinaryExpressionImpl
implements InExpression {
    private final Token notToken;

    public InExpressionImpl(Expression leftOperand, @Nullable Token not, Token operator, Expression rightOperand) {
        super(leftOperand, operator, rightOperand);
        this.notToken = not;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IN;
    }

    @Override
    @CheckForNull
    public Token notToken() {
        return this.notToken;
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.leftOperand(), this.notToken, this.operator(), this.rightOperand()).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

