/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.ControlFlowGraphBuilder;

public class ControlFlowGraph {
    private static final Logger LOG = Loggers.get(ControlFlowGraph.class);
    private final Set<CfgBlock> blocks;
    private final CfgBlock start;
    private final CfgBlock end;
    private static Set<Tree> treesWithCfgErrors = Collections.newSetFromMap(new WeakHashMap());

    public ControlFlowGraph(Set<CfgBlock> blocks, CfgBlock start, CfgBlock end) {
        this.blocks = blocks;
        this.start = start;
        this.end = end;
    }

    @CheckForNull
    private static ControlFlowGraph build(@Nullable StatementList statementList, PythonFile file) {
        if (!treesWithCfgErrors.contains(statementList)) {
            try {
                return new ControlFlowGraphBuilder(statementList).getCfg();
            }
            catch (Exception e) {
                treesWithCfgErrors.add(statementList);
                LOG.warn("Failed to build control flow graph in file [{}]: {}", (Object)file, (Object)e.getMessage());
            }
        }
        return null;
    }

    @CheckForNull
    public static ControlFlowGraph build(FunctionDef functionDef, PythonFile file) {
        return ControlFlowGraph.build(functionDef.body(), file);
    }

    @CheckForNull
    public static ControlFlowGraph build(FileInput fileInput, PythonFile file) {
        return ControlFlowGraph.build(fileInput.statements(), file);
    }

    public CfgBlock start() {
        return this.start;
    }

    public CfgBlock end() {
        return this.end;
    }

    public Set<CfgBlock> blocks() {
        return this.blocks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Function<Collection, List> sortedByDisplayString = list -> list.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
        List sortedBlocks = sortedByDisplayString.apply(this.blocks);
        int graphNodeId = 0;
        HashMap<CfgBlock, Integer> graphNodeIds = new HashMap<CfgBlock, Integer>();
        for (CfgBlock block : sortedBlocks) {
            graphNodeIds.put(block, graphNodeId);
            sb.append(graphNodeId).append("[label=\"").append(block.toString()).append("\"];");
            ++graphNodeId;
        }
        for (CfgBlock block : sortedBlocks) {
            int id = (Integer)graphNodeIds.get(block);
            for (CfgBlock successor : sortedByDisplayString.apply(block.successors())) {
                sb.append(id).append("->").append(graphNodeIds.get(successor)).append(";");
            }
            if (block.syntacticSuccessor() == null) continue;
            sb.append(id).append("->").append(graphNodeIds.get(block.syntacticSuccessor())).append("[style=dotted];");
        }
        return sb.toString();
    }
}

