/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.ItemOperationsType;
import org.sonar.python.types.InferredTypes;

@Rule(key="S5644")
public class ItemOperationsTypeCheck
extends ItemOperationsType {
    @Override
    public boolean isValidSubscription(Expression subscriptionObject, String requiredMethod, @Nullable String classRequiredMethod, List<LocationInFile> secondaries) {
        Symbol subscriptionCalleeSymbol;
        if (subscriptionObject.is(Tree.Kind.GENERATOR_EXPR)) {
            return false;
        }
        if (subscriptionObject.is(Tree.Kind.CALL_EXPR) && (subscriptionCalleeSymbol = ((CallExpression)subscriptionObject).calleeSymbol()) != null && subscriptionCalleeSymbol.is(Symbol.Kind.FUNCTION) && ((FunctionSymbol)subscriptionCalleeSymbol).isAsynchronous()) {
            secondaries.add(((FunctionSymbol)subscriptionCalleeSymbol).definitionLocation());
            return false;
        }
        if (subscriptionObject instanceof HasSymbol) {
            Symbol symbol = ((HasSymbol)((Object)subscriptionObject)).symbol();
            if (symbol == null || ItemOperationsTypeCheck.isTypingSymbol(symbol)) {
                return true;
            }
            if (symbol.is(Symbol.Kind.FUNCTION, Symbol.Kind.CLASS)) {
                secondaries.add(symbol.is(Symbol.Kind.FUNCTION) ? ((FunctionSymbol)symbol).definitionLocation() : ((ClassSymbol)symbol).definitionLocation());
                return ItemOperationsTypeCheck.canHaveMethod(symbol, requiredMethod, classRequiredMethod);
            }
        }
        InferredType type = subscriptionObject.type();
        secondaries.add(InferredTypes.typeClassLocation(type));
        return type.canHaveMember(requiredMethod);
    }

    @Override
    public String message(@Nullable String name, String missingMethod) {
        if (name != null) {
            return String.format("Fix this code; \"%s\" does not have a \"%s\" method.", name, missingMethod);
        }
        return String.format("Fix this code; this expression does not have a \"%s\" method.", missingMethod);
    }

    private static boolean isTypingSymbol(Symbol symbol) {
        String fullyQualifiedName = symbol.fullyQualifiedName();
        return fullyQualifiedName != null && fullyQualifiedName.startsWith("typing");
    }

    private static boolean canHaveMethod(Symbol symbol, String requiredMethod, @Nullable String classRequiredMethod) {
        if (symbol.is(Symbol.Kind.FUNCTION)) {
            return ((FunctionSymbol)symbol).hasDecorators();
        }
        ClassSymbol classSymbol = (ClassSymbol)symbol;
        return classSymbol.canHaveMember(requiredMethod) || classRequiredMethod != null && classSymbol.canHaveMember(classRequiredMethod) || classSymbol.hasDecorators();
    }
}

