/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.checks.IterationOnNonIterable;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.types.InferredTypes;

@Rule(key="S3862")
public class IterationOnNonIterableCheck
extends IterationOnNonIterable {
    private static final String MESSAGE = "Replace this expression with an iterable object.";

    @Override
    boolean isValidIterable(Expression expression, List<LocationInFile> secondaries) {
        Symbol symbol;
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(Tree.Kind.CALL_EXPR) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(Symbol.Kind.FUNCTION) && ((FunctionSymbol)calleeSymbol).isAsynchronous()) {
            secondaries.add(((FunctionSymbol)calleeSymbol).definitionLocation());
            return false;
        }
        if (expression instanceof HasSymbol && (symbol = ((HasSymbol)((Object)expression)).symbol()) != null) {
            if (symbol.is(Symbol.Kind.FUNCTION)) {
                FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                secondaries.add(functionSymbol.definitionLocation());
                return functionSymbol.hasDecorators();
            }
            if (symbol.is(Symbol.Kind.CLASS)) {
                secondaries.add(((ClassSymbol)symbol).definitionLocation());
                ClassSymbolImpl classSymbol = (ClassSymbolImpl)symbol;
                return classSymbol.hasSuperClassWithUnknownMetaClass() || classSymbol.hasUnresolvedTypeHierarchy();
            }
        }
        InferredType type = expression.type();
        secondaries.add(InferredTypes.typeClassLocation(type));
        return type.canHaveMember("__iter__") || type.canHaveMember("__getitem__");
    }

    @Override
    boolean isAsyncIterable(Expression expression) {
        CallExpression callExpression;
        Symbol calleeSymbol;
        if (expression.is(Tree.Kind.CALL_EXPR) && (calleeSymbol = (callExpression = (CallExpression)expression).calleeSymbol()) != null && calleeSymbol.is(Symbol.Kind.FUNCTION)) {
            return ((FunctionSymbol)calleeSymbol).isAsynchronous();
        }
        return expression.type().canHaveMember("__aiter__");
    }

    @Override
    String message(Expression expression, boolean isForLoop) {
        return isForLoop && this.isAsyncIterable(expression) ? "Add \"async\" before \"for\"; This expression is an async generator." : MESSAGE;
    }
}

