/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.python.checks.AbstractUnreadPrivateMembersCheck;

@Rule(key="S4487")
public class UnreadPrivateAttributesCheck
extends AbstractUnreadPrivateMembersCheck {
    private static final boolean DEFAULT_ENABLE_SINGLE_UNDERSCORE_ISSUES = false;
    @RuleProperty(key="enableSingleUnderscoreIssues", description="Enable issues on unread attributes with a single underscore prefix", defaultValue="false")
    public boolean enableSingleUnderscoreIssues = false;

    @Override
    String memberPrefix() {
        return this.enableSingleUnderscoreIssues ? "_" : "__";
    }

    @Override
    Symbol.Kind kind() {
        return Symbol.Kind.OTHER;
    }

    @Override
    String message(String memberName) {
        return "Remove this unread private attribute '" + memberName + "' or refactor the code to use its value.";
    }
}

