/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;

@Rule(key="S1721")
public class UselessParenthesisAfterKeywordCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Remove the parentheses after this \"%s\" keyword.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSERT_STMT, ctx -> UselessParenthesisAfterKeywordCheck.checkExpr(((AssertStatement)ctx.syntaxNode()).condition(), ctx, "assert"));
        context.registerSyntaxNodeConsumer(Tree.Kind.DEL_STMT, ctx -> UselessParenthesisAfterKeywordCheck.checkExpr(((DelStatement)ctx.syntaxNode()).expressions().get(0), ctx, "del"));
        context.registerSyntaxNodeConsumer(Tree.Kind.IF_STMT, ctx -> {
            IfStatement ifStmt = (IfStatement)ctx.syntaxNode();
            UselessParenthesisAfterKeywordCheck.checkExpr(ifStmt.condition(), ctx, ifStmt.keyword().value());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.WHILE_STMT, ctx -> {
            WhileStatement whileStmt = (WhileStatement)ctx.syntaxNode();
            UselessParenthesisAfterKeywordCheck.checkExpr(whileStmt.condition(), ctx, whileStmt.whileKeyword().value());
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, ctx -> UselessParenthesisAfterKeywordCheck.handleForStatement(ctx, (ForStatement)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> UselessParenthesisAfterKeywordCheck.handleRaiseStatement(ctx, (RaiseStatement)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.RETURN_STMT, ctx -> UselessParenthesisAfterKeywordCheck.handleReturnStatement(ctx, (ReturnStatement)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.YIELD_EXPR, ctx -> UselessParenthesisAfterKeywordCheck.handleYieldExpression(ctx, (YieldExpression)ctx.syntaxNode()));
        context.registerSyntaxNodeConsumer(Tree.Kind.EXCEPT_CLAUSE, ctx -> {
            Expression exception = ((ExceptClause)ctx.syntaxNode()).exception();
            if (exception != null) {
                UselessParenthesisAfterKeywordCheck.checkExprExcludeTuples(exception, ctx, "except");
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.NOT, ctx -> UselessParenthesisAfterKeywordCheck.handleNotOperator(ctx, (UnaryExpression)ctx.syntaxNode()));
    }

    private static void handleYieldExpression(SubscriptionContext ctx, YieldExpression yieldExpr) {
        if (yieldExpr.fromKeyword() == null && yieldExpr.expressions().size() == 1) {
            yieldExpr.expressions().forEach(e -> UselessParenthesisAfterKeywordCheck.checkExpr(e, ctx, "yield"));
        }
    }

    private static void handleReturnStatement(SubscriptionContext ctx, ReturnStatement retStmt) {
        Expression expr;
        if (retStmt.expressions().size() == 1 && ((expr = retStmt.expressions().get(0)).is(Tree.Kind.PARENTHESIZED) || expr.is(Tree.Kind.TUPLE) && !((Tuple)expr).elements().isEmpty()) && expr.firstToken().line() == expr.lastToken().line()) {
            ctx.addIssue(expr, String.format(MESSAGE, "return"));
        }
    }

    private static void handleNotOperator(SubscriptionContext ctx, UnaryExpression unary) {
        Expression negatedExpr = unary.expression();
        if (negatedExpr.is(Tree.Kind.PARENTHESIZED) && ((negatedExpr = ((ParenthesizedExpression)negatedExpr).expression()).is(Tree.Kind.COMPARISON) || !(negatedExpr instanceof BinaryExpression))) {
            ctx.addIssue(negatedExpr, String.format(MESSAGE, "not"));
        }
    }

    private static void handleRaiseStatement(SubscriptionContext ctx, RaiseStatement raiseStmt) {
        if (!raiseStmt.expressions().isEmpty()) {
            UselessParenthesisAfterKeywordCheck.checkExpr(raiseStmt.expressions().get(0), ctx, "raise");
        }
    }

    private static void handleForStatement(SubscriptionContext ctx, ForStatement forStmt) {
        if (forStmt.expressions().size() == 1) {
            UselessParenthesisAfterKeywordCheck.checkExpr(forStmt.expressions().get(0), ctx, "for");
        }
        if (forStmt.testExpressions().size() == 1) {
            UselessParenthesisAfterKeywordCheck.checkExpr(forStmt.testExpressions().get(0), ctx, "in");
        }
    }

    private static void checkExprExcludeTuples(Expression expr, SubscriptionContext ctx, String keyword) {
        UselessParenthesisAfterKeywordCheck.checkExpr(expr, ctx, keyword, false);
    }

    private static void checkExpr(Expression expr, SubscriptionContext ctx, String keyword) {
        UselessParenthesisAfterKeywordCheck.checkExpr(expr, ctx, keyword, true);
    }

    private static void checkExpr(Expression expr, SubscriptionContext ctx, String keyword, boolean raiseForTuple) {
        if ((expr.is(Tree.Kind.PARENTHESIZED) || raiseForTuple && expr.is(Tree.Kind.TUPLE)) && expr.firstToken().line() == expr.lastToken().line()) {
            ctx.addIssue(expr, String.format(MESSAGE, keyword));
        }
    }
}

