/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.semantic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.semantic.AmbiguousSymbolImpl;
import org.sonar.python.semantic.ClassSymbolImpl;
import org.sonar.python.semantic.FunctionSymbolImpl;
import org.sonar.python.semantic.SymbolImpl;
import org.sonar.python.semantic.SymbolTableBuilder;
import org.sonar.python.semantic.SymbolUtils;

public class ProjectLevelSymbolTable {
    private final Map<String, Set<Symbol>> globalSymbolsByModuleName;
    private Map<String, Symbol> globalSymbolsByFQN;

    public static ProjectLevelSymbolTable empty() {
        return new ProjectLevelSymbolTable(Collections.emptyMap());
    }

    public static ProjectLevelSymbolTable from(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        return new ProjectLevelSymbolTable(globalSymbolsByModuleName);
    }

    public ProjectLevelSymbolTable() {
        this.globalSymbolsByModuleName = new HashMap<String, Set<Symbol>>();
    }

    private ProjectLevelSymbolTable(Map<String, Set<Symbol>> globalSymbolsByModuleName) {
        this.globalSymbolsByModuleName = new HashMap<String, Set<Symbol>>(globalSymbolsByModuleName);
    }

    public void addModule(FileInput fileInput, String packageName, PythonFile pythonFile) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName, pythonFile);
        String fullyQualifiedModuleName = SymbolUtils.fullyQualifiedModuleName(packageName, pythonFile.fileName());
        fileInput.accept(symbolTableBuilder);
        HashSet<SymbolImpl> globalSymbols = new HashSet<SymbolImpl>();
        for (Symbol globalVariable : fileInput.globalVariables()) {
            String fullyQualifiedVariableName = globalVariable.fullyQualifiedName();
            if (fullyQualifiedVariableName != null && !fullyQualifiedVariableName.startsWith(fullyQualifiedModuleName) || globalVariable.usages().stream().anyMatch(u -> u.kind().equals((Object)Usage.Kind.IMPORT))) continue;
            if (globalVariable.kind() == Symbol.Kind.CLASS) {
                globalSymbols.add(((ClassSymbolImpl)globalVariable).copyWithoutUsages());
                continue;
            }
            if (globalVariable.kind() == Symbol.Kind.FUNCTION) {
                globalSymbols.add(new FunctionSymbolImpl(globalVariable.name(), (FunctionSymbol)globalVariable));
                continue;
            }
            globalSymbols.add(new SymbolImpl(globalVariable.name(), fullyQualifiedModuleName + "." + globalVariable.name(), globalVariable.annotatedTypeName()));
        }
        this.globalSymbolsByModuleName.put(fullyQualifiedModuleName, globalSymbols);
    }

    private Map<String, Symbol> globalSymbolsByFQN() {
        if (this.globalSymbolsByFQN == null) {
            this.globalSymbolsByFQN = this.globalSymbolsByModuleName.values().stream().flatMap(Collection::stream).filter(symbol -> symbol.fullyQualifiedName() != null).collect(Collectors.toMap(Symbol::fullyQualifiedName, Function.identity(), (xva$0, xva$1) -> AmbiguousSymbolImpl.create(xva$0, xva$1)));
        }
        return this.globalSymbolsByFQN;
    }

    @CheckForNull
    public Symbol getSymbol(@Nullable String fullyQualifiedName) {
        return this.globalSymbolsByFQN().get(fullyQualifiedName);
    }

    @CheckForNull
    public Set<Symbol> getSymbolsFromModule(@Nullable String moduleName) {
        return this.globalSymbolsByModuleName.get(moduleName);
    }
}

