/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.InferredTypes;

public class NumericLiteralImpl
extends PyTree
implements NumericLiteral {
    private final String valueAsString;
    private final Token token;
    private final InferredType type;

    NumericLiteralImpl(Token token) {
        this.token = token;
        this.valueAsString = token.value();
        this.type = this.computeType();
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NUMERIC_LITERAL;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNumericLiteral(this);
    }

    @Override
    public long valueAsLong() {
        String literalValue = this.valueAsString.replace("_", "");
        if (literalValue.startsWith("0b") || literalValue.startsWith("0B")) {
            return Integer.valueOf(literalValue.substring(2), 2).intValue();
        }
        if (this.valueAsString.endsWith("L") || this.valueAsString.endsWith("l")) {
            literalValue = literalValue.substring(0, literalValue.length() - 1);
        }
        return Long.parseLong(literalValue);
    }

    @Override
    public String valueAsString() {
        return this.valueAsString;
    }

    @Override
    public List<Tree> computeChildren() {
        return Collections.singletonList(this.token);
    }

    @Override
    public InferredType type() {
        return this.type;
    }

    private InferredType computeType() {
        String valueAsStringLowerCase = this.valueAsString.toLowerCase(Locale.ROOT);
        if (valueAsStringLowerCase.contains("j")) {
            return InferredTypes.COMPLEX;
        }
        if (this.valueAsString.contains(".") || valueAsStringLowerCase.contains("e")) {
            return InferredTypes.FLOAT;
        }
        return InferredTypes.INT;
    }
}

