/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.InferredType;
import org.sonar.python.tree.PyTree;
import org.sonar.python.types.HasTypeDependencies;

public class ParenthesizedExpressionImpl
extends PyTree
implements ParenthesizedExpression,
HasTypeDependencies {
    private final Token leftParenthesis;
    private final Expression expression;
    private final Token rightParenthesis;

    public ParenthesizedExpressionImpl(Token leftParenthesis, Expression expression, Token rightParenthesis) {
        this.leftParenthesis = leftParenthesis;
        this.expression = expression;
        this.rightParenthesis = rightParenthesis;
    }

    @Override
    public Token leftParenthesis() {
        return this.leftParenthesis;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public Token rightParenthesis() {
        return this.rightParenthesis;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParenthesizedExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.leftParenthesis, this.expression, this.rightParenthesis).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARENTHESIZED;
    }

    @Override
    public InferredType type() {
        return this.expression.type();
    }

    @Override
    public List<Expression> typeDependencies() {
        return Collections.singletonList(this.expression);
    }
}

