/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonTokenType;

public class CheckUtils {
    private CheckUtils() {
    }

    public static boolean areEquivalent(@Nullable Tree leftTree, @Nullable Tree rightTree) {
        if (leftTree == rightTree) {
            return true;
        }
        if (leftTree == null || rightTree == null) {
            return false;
        }
        if (leftTree.getKind() != rightTree.getKind() || leftTree.children().size() != rightTree.children().size()) {
            return false;
        }
        if (leftTree.children().isEmpty() && rightTree.children().isEmpty()) {
            return CheckUtils.areLeavesEquivalent(leftTree, rightTree);
        }
        List<Tree> children1 = leftTree.children();
        List<Tree> children2 = rightTree.children();
        for (int i = 0; i < children1.size(); ++i) {
            if (CheckUtils.areEquivalent(children1.get(i), children2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areLeavesEquivalent(Tree leftLeaf, Tree rightLeaf) {
        if (leftLeaf.firstToken() == null && rightLeaf.firstToken() == null) {
            return true;
        }
        return leftLeaf.firstToken().type().equals(PythonTokenType.INDENT) || leftLeaf.firstToken().type().equals(PythonTokenType.DEDENT) || leftLeaf.firstToken().value().equals(rightLeaf.firstToken().value());
    }

    public static ClassDef getParentClassDef(Tree tree) {
        for (Tree current = tree.parent(); current != null; current = current.parent()) {
            if (current.is(Tree.Kind.CLASSDEF)) {
                return (ClassDef)current;
            }
            if (!current.is(Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA)) continue;
            return null;
        }
        return null;
    }

    public static boolean classHasInheritance(ClassDef classDef) {
        ArgList argList = classDef.args();
        if (argList == null) {
            return false;
        }
        List<Argument> arguments = argList.arguments();
        if (arguments.isEmpty()) {
            return false;
        }
        return arguments.size() != 1 || !"object".equals(arguments.get(0).firstToken().value());
    }
}

