/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.cfg.fixpoint.LiveVariablesAnalysis;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S1854")
public class DeadStoreUtils {
    private DeadStoreUtils() {
    }

    static List<UnnecessaryAssignment> findUnnecessaryAssignments(CfgBlock block, LiveVariablesAnalysis.LiveVariables blockLiveVariables, FunctionDef functionDef) {
        ArrayList<UnnecessaryAssignment> unnecessaryAssignments = new ArrayList<UnnecessaryAssignment>();
        HashSet<Symbol> willBeRead = new HashSet<Symbol>(blockLiveVariables.getOut());
        ListIterator<Tree> elementsReverseIterator = block.elements().listIterator(block.elements().size());
        while (elementsReverseIterator.hasPrevious()) {
            Tree element = elementsReverseIterator.previous();
            blockLiveVariables.getSymbolReadWrites(element).forEach((symbol, symbolReadWrite) -> {
                if (symbolReadWrite.isWrite() && !symbolReadWrite.isRead()) {
                    if (!willBeRead.contains(symbol) && functionDef.localVariables().contains(symbol)) {
                        unnecessaryAssignments.add(new UnnecessaryAssignment((Symbol)symbol, element));
                    }
                    willBeRead.remove(symbol);
                } else if (symbolReadWrite.isRead()) {
                    willBeRead.add((Symbol)symbol);
                }
            });
        }
        return unnecessaryAssignments;
    }

    static boolean isParameter(Tree element) {
        return element.is(Tree.Kind.PARAMETER) || TreeUtils.firstAncestorOfKind(element, Tree.Kind.PARAMETER) != null;
    }

    static boolean isUsedInSubFunction(Symbol symbol, FunctionDef functionDef) {
        return symbol.usages().stream().anyMatch(usage -> TreeUtils.firstAncestorOfKind(usage.tree(), Tree.Kind.FUNCDEF, Tree.Kind.LAMBDA) != functionDef);
    }

    static class UnnecessaryAssignment {
        final Symbol symbol;
        final Tree element;

        private UnnecessaryAssignment(Symbol symbol, Tree element) {
            this.symbol = symbol;
            this.element = element;
        }
    }
}

