/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DictionaryLiteralElement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.AbstractDuplicateKeyCheck;

@Rule(key="S5780")
public class DictionaryDuplicateKeyCheck
extends AbstractDuplicateKeyCheck {
    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.DICTIONARY_LITERAL, ctx -> {
            DictionaryLiteral dictionaryLiteral = (DictionaryLiteral)ctx.syntaxNode();
            HashSet<Integer> issueIndexes = new HashSet<Integer>();
            if (dictionaryLiteral.elements().size() > 100) {
                return;
            }
            for (int i = 0; i < dictionaryLiteral.elements().size(); ++i) {
                if (!dictionaryLiteral.elements().get(i).is(Tree.Kind.KEY_VALUE_PAIR) || issueIndexes.contains(i)) continue;
                Expression key = ((KeyValuePair)dictionaryLiteral.elements().get(i)).key();
                List<Tree> duplicateKeys = this.findIdenticalKeys(i, dictionaryLiteral.elements(), issueIndexes);
                if (duplicateKeys.isEmpty()) continue;
                PythonCheck.PreciseIssue issue = ctx.addIssue(key, "Change or remove duplicates of this key.");
                duplicateKeys.forEach(d -> issue.secondary((Tree)d, "Duplicate key"));
            }
        });
    }

    private List<Tree> findIdenticalKeys(int startIndex, List<DictionaryLiteralElement> elements, Set<Integer> issueIndexes) {
        Expression key = ((KeyValuePair)elements.get(startIndex)).key();
        ArrayList<Tree> duplicates = new ArrayList<Tree>();
        for (int i = startIndex + 1; i < elements.size(); ++i) {
            Expression comparedKey;
            if (!elements.get(i).is(Tree.Kind.KEY_VALUE_PAIR) || !this.isSameKey(key, comparedKey = ((KeyValuePair)elements.get(i)).key())) continue;
            issueIndexes.add(i);
            duplicates.add(comparedKey);
        }
        return duplicates;
    }
}

