/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="FunctionComplexity")
public class FunctionComplexityCheck
extends PythonSubscriptionCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 15;
    private static final String MESSAGE = "Function has a complexity of %s which is greater than %s authorized.";
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity in function", defaultValue="15")
    int maximumFunctionComplexityThreshold = 15;

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, ctx -> {
            FunctionDef funcDef = (FunctionDef)ctx.syntaxNode();
            int complexity = ComplexityVisitor.complexity(funcDef);
            if (complexity > this.maximumFunctionComplexityThreshold) {
                String message = String.format(MESSAGE, complexity, this.maximumFunctionComplexityThreshold);
                ctx.addIssue(funcDef.name(), message).withCost(complexity - this.maximumFunctionComplexityThreshold);
            }
        });
    }
}

