/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.Expressions;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5828")
public class InvalidOpenModeCheck
extends PythonSubscriptionCheck {
    private static final String VALID_MODES = "rwatb+Ux";
    private static final Pattern INVALID_CHARACTERS = Pattern.compile("[^rwatb+Ux]");
    private static final String MESSAGE = "Fix this invalid mode string.";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            Expression assignedValue;
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            Symbol calleeSymbol = callExpression.calleeSymbol();
            if (calleeSymbol == null || !"open".equals(calleeSymbol.fullyQualifiedName())) {
                return;
            }
            List<Argument> arguments = callExpression.arguments();
            RegularArgument modeArgument = TreeUtils.nthArgumentOrKeyword(1, "mode", arguments);
            if (modeArgument == null) {
                return;
            }
            Expression modeExpression = modeArgument.expression();
            if (modeExpression.is(Tree.Kind.STRING_LITERAL)) {
                InvalidOpenModeCheck.checkOpenMode(ctx, modeExpression, (StringLiteral)modeExpression);
            } else if (modeExpression.is(Tree.Kind.NAME) && (assignedValue = Expressions.singleAssignedValue((Name)modeExpression)) != null && assignedValue.is(Tree.Kind.STRING_LITERAL)) {
                InvalidOpenModeCheck.checkOpenMode(ctx, modeExpression, (StringLiteral)assignedValue);
            }
        });
    }

    private static void checkOpenMode(SubscriptionContext ctx, Expression openExpression, StringLiteral stringLiteral) {
        if (stringLiteral.stringElements().stream().anyMatch(StringElement::isInterpolated)) {
            return;
        }
        String mode = stringLiteral.trimmedQuotesValue();
        if (mode.length() > VALID_MODES.length() || INVALID_CHARACTERS.matcher(mode).matches()) {
            InvalidOpenModeCheck.raiseIssue(openExpression, stringLiteral, ctx);
            return;
        }
        HashSet<Character> modeSet = new HashSet<Character>();
        for (int i = 0; i < mode.length(); ++i) {
            char character = mode.charAt(i);
            if (modeSet.add(Character.valueOf(character))) continue;
            InvalidOpenModeCheck.raiseIssue(openExpression, stringLiteral, ctx);
            return;
        }
        if (InvalidOpenModeCheck.isInvalidMode(modeSet)) {
            InvalidOpenModeCheck.raiseIssue(openExpression, stringLiteral, ctx);
        }
    }

    private static boolean isInvalidMode(Set<Character> modeSet) {
        boolean creating = modeSet.contains(Character.valueOf('x'));
        boolean universalNewlines = modeSet.contains(Character.valueOf('U'));
        boolean reading = modeSet.contains(Character.valueOf('r')) || universalNewlines;
        boolean writing = modeSet.contains(Character.valueOf('w'));
        boolean appending = modeSet.contains(Character.valueOf('a'));
        boolean text = modeSet.contains(Character.valueOf('t'));
        boolean binary = modeSet.contains(Character.valueOf('b'));
        boolean updating = modeSet.contains(Character.valueOf('+'));
        if (universalNewlines && (writing || appending || creating || updating)) {
            return true;
        }
        if (text && binary) {
            return true;
        }
        return (reading ? 1 : 0) + (writing ? 1 : 0) + (appending ? 1 : 0) + (creating ? 1 : 0) != 1;
    }

    private static void raiseIssue(Expression expression, StringLiteral stringLiteral, SubscriptionContext ctx) {
        PythonCheck.PreciseIssue issue = ctx.addIssue(expression, MESSAGE);
        if (expression != stringLiteral) {
            issue.secondary(stringLiteral, null);
        }
    }
}

