/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Was %s= meant instead?";

    @Override
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
            if (assignment.assignedValue().is(Tree.Kind.UNARY_PLUS) || assignment.assignedValue().is(Tree.Kind.UNARY_MINUS)) {
                if (assignment.equalTokens().size() > 1) {
                    return;
                }
                UnaryExpression unaryExpression = (UnaryExpression)assignment.assignedValue();
                Token equalToken = assignment.equalTokens().get(0);
                Token unaryOperator = unaryExpression.operator();
                Token variableLastToken = assignment.lhsExpressions().get(0).lastToken();
                if (WrongAssignmentOperatorCheck.noSpacingBetween(variableLastToken, equalToken) && WrongAssignmentOperatorCheck.noSpacingBetween(unaryOperator, unaryExpression.expression().firstToken())) {
                    return;
                }
                if (WrongAssignmentOperatorCheck.noSpacingBetween(equalToken, unaryOperator)) {
                    ctx.addIssue(equalToken, unaryOperator, String.format(MESSAGE, unaryOperator.value()));
                }
            }
        });
    }

    private static boolean noSpacingBetween(Token first, Token second) {
        return first.line() == second.line() && first.column() + first.value().length() == second.column();
    }
}

